/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.events.build;

import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.events.build.AbstractBuildRequestEvent;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.personal.PatchArchive;

public class PersonalBuildRequestEvent
extends AbstractBuildRequestEvent {
    private long number;
    private User user;
    private PatchArchive patch;

    public PersonalBuildRequestEvent(Object source, long number, BuildRevision revision, User user, PatchArchive patch, Project project, BuildSpecification specification) {
        super(source, revision, project, specification);
        this.number = number;
        this.user = user;
        this.patch = patch;
    }

    public Entity getOwner() {
        return this.user;
    }

    public boolean isPersonal() {
        return true;
    }

    public BuildResult createResult(ProjectManager projectManager, UserManager userManager) {
        return new BuildResult(this.user, this.getProject(), this.getSpecification(), this.number);
    }

    public PatchArchive getPatch() {
        return this.patch;
    }

    public long getNumber() {
        return this.number;
    }

    public User getUser() {
        return this.user;
    }

    public String toString() {
        String result = "Personal Build Request Event: " + this.number;
        if (this.user != null) {
            result = result + ": " + this.user.getLogin();
        }
        return result;
    }
}

