/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.events.build;

import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.events.build.AbstractBuildRequestEvent;
import com.zutubi.pulse.model.BuildReason;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.UserManager;

public class BuildRequestEvent
extends AbstractBuildRequestEvent {
    private BuildReason reason;

    public BuildRequestEvent(Object source, BuildReason reason, Project project, BuildSpecification specification, BuildRevision revision) {
        super(source, revision, project, specification);
        this.reason = reason;
    }

    public Entity getOwner() {
        return this.getProject();
    }

    public boolean isPersonal() {
        return false;
    }

    public BuildReason getReason() {
        return this.reason;
    }

    public BuildResult createResult(ProjectManager projectManager, UserManager userManager) {
        return new BuildResult(this.reason, this.getProject(), this.getSpecification(), projectManager.getNextBuildNumber(this.getProject()), this.getRevision().isUser());
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("Build Request Event");
        if (this.getProject() != null) {
            buff.append(": ").append(this.getProject().getName());
        }
        if (this.getReason() != null) {
            buff.append(": ").append(this.getReason().getSummary());
        }
        return buff.toString();
    }
}

