/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.events.build;

import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.util.TimeStamps;

public abstract class AbstractBuildRequestEvent
extends Event {
    private BuildRevision revision;
    private Project project;
    private BuildSpecification specification;
    private long queued;

    public AbstractBuildRequestEvent(Object source, BuildRevision revision, Project project, BuildSpecification specification) {
        super(source);
        this.revision = revision;
        this.project = project;
        this.specification = specification;
        this.queued = System.currentTimeMillis();
    }

    public abstract Entity getOwner();

    public abstract boolean isPersonal();

    public abstract BuildResult createResult(ProjectManager var1, UserManager var2);

    public BuildRevision getRevision() {
        return this.revision;
    }

    public Project getProject() {
        return this.project;
    }

    public BuildSpecification getSpecification() {
        return this.specification;
    }

    public long getQueued() {
        return this.queued;
    }

    public String getPrettyQueueTime() {
        return TimeStamps.getPrettyTime((long)this.queued);
    }
}

