/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.condition;

import com.zutubi.pulse.condition.NotifyCondition;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.User;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundNotifyCondition
implements NotifyCondition {
    private List<NotifyCondition> children;
    private boolean disjunctive;

    public CompoundNotifyCondition(NotifyCondition a, NotifyCondition b, boolean disjunctive) {
        this.children = new LinkedList<NotifyCondition>();
        this.children.add(a);
        this.children.add(b);
        this.disjunctive = disjunctive;
    }

    public CompoundNotifyCondition(List<NotifyCondition> children, boolean disjunctive) {
        this.children = children;
        this.disjunctive = disjunctive;
    }

    @Override
    public boolean satisfied(BuildResult result, User user) {
        boolean ret = !this.disjunctive;
        for (NotifyCondition child : this.children) {
            if (child.satisfied(result, user) != this.disjunctive) continue;
            ret = this.disjunctive;
            break;
        }
        return ret;
    }

    public List<NotifyCondition> getChildren() {
        return this.children;
    }

    public boolean isDisjunctive() {
        return this.disjunctive;
    }
}

