/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.committransformers;

import com.zutubi.pulse.committransformers.CommitMessageBuilder;
import com.zutubi.pulse.model.CommitMessageTransformer;

public class LinkCommitMessageTransformer
extends CommitMessageTransformer {
    public static final String EXPRESSION_PROPERTY = "standard.expression";
    public static final String LINK_PROPERTY = "standard.link";

    public LinkCommitMessageTransformer() {
    }

    public LinkCommitMessageTransformer(String name) {
        this.setName(name);
    }

    public LinkCommitMessageTransformer(String name, String expression, String link) {
        this.setName(name);
        this.setExpression(expression);
        this.setLink(link);
    }

    public String getExpression() {
        return this.getProperties().getProperty(EXPRESSION_PROPERTY);
    }

    public void setExpression(String expression) {
        this.getProperties().setProperty(EXPRESSION_PROPERTY, expression);
    }

    public String getLink() {
        return this.getProperties().getProperty(LINK_PROPERTY);
    }

    public void setLink(String link) {
        this.getProperties().setProperty(LINK_PROPERTY, link);
    }

    public String getType() {
        return "Link";
    }

    public CommitMessageBuilder transform(CommitMessageBuilder builder) {
        String replacement = "<a href='" + this.getLink() + "'>$0</a>";
        builder.replace(this.getExpression(), replacement);
        return builder;
    }
}

