/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.committransformers;

import com.zutubi.pulse.committransformers.CommitMessageTransformerManager;
import com.zutubi.pulse.committransformers.CustomHandler;
import com.zutubi.pulse.committransformers.JiraHandler;
import com.zutubi.pulse.committransformers.LinkHandler;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.persistence.CommitMessageTransformerDao;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommitMessageTransformerManager
implements CommitMessageTransformerManager {
    private CommitMessageTransformerDao commitMessageTransformerDao;
    private Map<String, Class> transformerTypes = new HashMap<String, Class>();

    public DefaultCommitMessageTransformerManager() {
        this.transformerTypes.put("custom", CustomHandler.class);
        this.transformerTypes.put("jira", JiraHandler.class);
        this.transformerTypes.put("link", LinkHandler.class);
    }

    @Override
    public void save(CommitMessageTransformer entity) {
        this.commitMessageTransformerDao.save(entity);
    }

    @Override
    public void delete(CommitMessageTransformer entity) {
        this.commitMessageTransformerDao.delete(entity);
    }

    @Override
    public CommitMessageTransformer getById(long id) {
        return (CommitMessageTransformer)((Object)this.commitMessageTransformerDao.findById(id));
    }

    @Override
    public List<CommitMessageTransformer> getCommitMessageTransformers() {
        return this.commitMessageTransformerDao.findAll();
    }

    @Override
    public List<CommitMessageTransformer> getByProject(Project project) {
        return this.commitMessageTransformerDao.findByProject(project);
    }

    @Override
    public CommitMessageTransformer getByName(String name) {
        return this.commitMessageTransformerDao.findByName(name);
    }

    public void setCommitMessageTransformerDao(CommitMessageTransformerDao commitMessageTransformerDao) {
        this.commitMessageTransformerDao = commitMessageTransformerDao;
    }

    @Override
    public List<String> getTransformerTypes() {
        return new LinkedList<String>(this.transformerTypes.keySet());
    }

    @Override
    public Class getTransformerHandler(String type) {
        return this.transformerTypes.get(type);
    }
}

