/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.committransformers;

import com.zutubi.pulse.committransformers.CommitMessageHandler;
import com.zutubi.pulse.committransformers.CommitMessageTransformerManager;
import com.zutubi.pulse.committransformers.CustomCommitMessageTransformer;
import com.zutubi.pulse.committransformers.CustomHandler;
import com.zutubi.pulse.committransformers.JiraCommitMessageTransformer;
import com.zutubi.pulse.committransformers.JiraHandler;
import com.zutubi.pulse.committransformers.LinkCommitMessageTransformer;
import com.zutubi.pulse.committransformers.LinkHandler;
import com.zutubi.pulse.committransformers.SelectType;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.wizard.Wizard;
import com.zutubi.pulse.wizard.WizardTransition;
import com.zutubi.validation.Validateable;
import com.zutubi.validation.ValidationContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCommitMessageTransformerWizard
implements Wizard,
Validateable {
    private CommitMessageTransformerManager transformerManager;
    private ProjectManager projectManager;
    private ObjectFactory objectFactory;
    private Object currentState;
    private SelectType selectState;
    private long projectId = -1L;
    private Map<String, Object> handlers = new HashMap<String, Object>();

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    @Override
    public Object getCurrentState() {
        return this.currentState;
    }

    @Override
    public List<WizardTransition> getAvailableActions() {
        if (this.currentState == this.selectState) {
            return Arrays.asList(WizardTransition.NEXT, WizardTransition.CANCEL);
        }
        return Arrays.asList(WizardTransition.PREVIOUS, WizardTransition.FINISH, WizardTransition.CANCEL);
    }

    @Override
    public void doFinish() {
        Object o = this.handlers.get(this.selectState.getType());
        if (o instanceof LinkHandler) {
            LinkHandler handler = (LinkHandler)o;
            LinkCommitMessageTransformer transformer = new LinkCommitMessageTransformer();
            transformer.setExpression(handler.getExpression());
            transformer.setLink(handler.getLink());
            transformer.setName(handler.getName());
            if (this.projectId != -1L) {
                transformer.getProjects().add(this.projectId);
            }
            this.transformerManager.save(transformer);
        } else if (o instanceof JiraHandler) {
            JiraHandler handler = (JiraHandler)o;
            JiraCommitMessageTransformer transformer = new JiraCommitMessageTransformer();
            transformer.setName(handler.getName());
            transformer.setUrl(handler.getUrl());
            if (this.projectId != -1L) {
                transformer.getProjects().add(this.projectId);
            }
            this.transformerManager.save(transformer);
        } else if (o instanceof CustomHandler) {
            CustomHandler handler = (CustomHandler)o;
            CustomCommitMessageTransformer transformer = new CustomCommitMessageTransformer();
            transformer.setName(handler.getName());
            transformer.setExpression(handler.getExpression());
            transformer.setReplacement(handler.getReplacement());
            if (this.projectId != -1L) {
                transformer.getProjects().add(this.projectId);
            }
            this.transformerManager.save(transformer);
        }
    }

    @Override
    public Object doNext() {
        if (this.currentState == this.selectState) {
            this.currentState = this.handlers.get(this.selectState.getType());
        }
        return this.currentState;
    }

    @Override
    public Object doPrevious() {
        this.currentState = this.selectState;
        return this.currentState;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void initialise() {
        List<String> types = this.transformerManager.getTransformerTypes();
        this.selectState = new SelectType(types);
        this.currentState = this.selectState;
        for (String type : types) {
            try {
                Class handlerClass = this.transformerManager.getTransformerHandler(type);
                Object handler = this.objectFactory.buildBean(handlerClass);
                this.handlers.put(type, handler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object doRestart() {
        this.currentState = this.selectState;
        return this.currentState;
    }

    public void validate(ValidationContext context) {
        CommitMessageTransformer transformer;
        if (this.currentState instanceof CommitMessageHandler && (transformer = this.transformerManager.getByName(((CommitMessageHandler)this.currentState).getName())) != null) {
            context.addFieldError("name", context.getText("name.invalid"));
        }
    }

    public void setCommitMessageTransformerManager(CommitMessageTransformerManager commitMessageTransformerManager) {
        this.transformerManager = commitMessageTransformerManager;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }
}

