/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.command.DataCommand;
import com.zutubi.pulse.command.HelpCommand;
import com.zutubi.pulse.transfer.JDBCTransferException;
import com.zutubi.pulse.transfer.TransferAPI;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportCommand
extends DataCommand {
    @Override
    public int doExecute(BootContext context) throws IOException, ParseException {
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(this.getSharedOptions(), context.getCommandArgv(), true);
        String[] args = commandLine.getArgs();
        if (args.length == 0) {
            HelpCommand helpCommand = new HelpCommand();
            helpCommand.showHelp(context.getArgv()[0], (Command)this);
            return 1;
        }
        File inFile = new File(args[0]);
        if (!inFile.exists()) {
            System.err.println("Input file '" + inFile.getPath() + "' does not exist");
            return 2;
        }
        TransferAPI transferAPI = new TransferAPI();
        try {
            transferAPI.restore(this.configuration, inFile, this.dataSource);
        }
        catch (JDBCTransferException e) {
            System.err.println("Error importing data from database located at " + this.databaseConfig.getUrl() + ".  Trace below:");
            e.printStackTrace(System.err);
            return 2;
        }
        catch (Exception e) {
            System.err.println("Error importing data.  Trace below:");
            e.printStackTrace(System.err);
            return 2;
        }
        return 0;
    }

    public List<String> getUsages() {
        return Arrays.asList("<input file>");
    }

    public String getHelp() {
        return "imports the Pulse database from a file";
    }

    public String getDetailedHelp() {
        return "Imports the data in the given file to the current Pulse database.  This\ndata should previously have been exported from Pulse, and the target\ndatabase should be empty.";
    }

    public List<String> getAliases() {
        return Arrays.asList("im", "imp");
    }

    public static void main(String[] argv) {
        ImportCommand command = new ImportCommand();
        try {
            command.execute(new BootContext(null, argv, null, null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

