/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.command.DataCommand;
import com.zutubi.pulse.command.HelpCommand;
import com.zutubi.pulse.transfer.JDBCTransferException;
import com.zutubi.pulse.transfer.TransferAPI;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCommand
extends DataCommand {
    @Override
    public int doExecute(BootContext context) throws IOException, ParseException {
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(this.getSharedOptions(), context.getCommandArgv(), true);
        String[] args = commandLine.getArgs();
        if (args.length == 0) {
            HelpCommand helpCommand = new HelpCommand();
            helpCommand.showHelp(context.getArgv()[0], (Command)this);
            return 1;
        }
        File outFile = new File(args[0]);
        if (outFile.exists() && !outFile.delete()) {
            System.err.println("Unable to remove existing file '" + outFile.getPath() + "'");
            return 2;
        }
        try {
            if (!outFile.createNewFile()) {
                System.err.println("Unable to create output file '" + outFile.getPath() + "'");
                return 2;
            }
        }
        catch (IOException e) {
            System.err.println("Unable to create output file '" + outFile.getPath() + "': " + e.getMessage());
            return 2;
        }
        TransferAPI transferAPI = new TransferAPI();
        try {
            transferAPI.dump(this.configuration, this.dataSource, outFile);
        }
        catch (JDBCTransferException e) {
            System.err.println("Error exporting data from database located at " + this.databaseConfig.getUrl() + ".  Trace below:");
            e.printStackTrace(System.err);
            return 2;
        }
        catch (Exception e) {
            System.err.println("Error exporting data.  Trace below:");
            e.printStackTrace(System.err);
            return 2;
        }
        return 0;
    }

    public List<String> getUsages() {
        return Arrays.asList("<output file>");
    }

    public String getHelp() {
        return "exports the Pulse database to a file";
    }

    public String getDetailedHelp() {
        return "Exports the data in the current Pulse database to a file.  This data can\nthen be imported into another database (after updating your Pulse\nconfiguration).";
    }

    public List<String> getAliases() {
        return Arrays.asList("ex", "exp");
    }

    public static void main(String[] argv) {
        ExportCommand command = new ExportCommand();
        try {
            command.execute(new BootContext(null, argv, null, null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

