/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.bootstrap.SystemBootstrapManager;
import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataCommand
implements Command {
    private static final String ENV_PULSE_CONFIG = "PULSE_CONFIG";
    private String pulseData = null;
    private String pulseConfig;
    protected DataSource dataSource;
    protected DatabaseConfig databaseConfig;
    protected MutableConfiguration configuration;

    public void setConfig(String path) {
        this.pulseConfig = path;
    }

    public void setData(String data) {
        this.pulseData = data;
    }

    public int execute(BootContext context) throws ParseException, IOException {
        this.parse(context.getCommandArgv());
        if (TextUtils.stringSet((String)this.pulseData)) {
            System.setProperty("pulse.data", this.pulseData);
        }
        if (TextUtils.stringSet((String)this.pulseConfig)) {
            System.setProperty("pulse.config", this.pulseConfig);
        } else if (TextUtils.stringSet((String)System.getenv(ENV_PULSE_CONFIG))) {
            System.setProperty("pulse.config", System.getenv(ENV_PULSE_CONFIG));
        }
        SystemBootstrapManager sbm = new SystemBootstrapManager();
        sbm.loadBootstrapContext();
        ComponentContext.addClassPathContextDefinitions((String[])new String[]{"classpath:/com/zutubi/pulse/bootstrap/context/databaseContext.xml"});
        ComponentContext.addClassPathContextDefinitions((String[])new String[]{"classpath:/com/zutubi/pulse/bootstrap/context/hibernateMappingsContext.xml"});
        this.dataSource = (DataSource)ComponentContext.getBean((String)"dataSource");
        this.configuration = new MutableConfiguration();
        List mappings = (List)ComponentContext.getBean((String)"hibernateMappings");
        for (String mapping : mappings) {
            ClassPathResource resource = new ClassPathResource(mapping);
            this.configuration.addInputStream(resource.getInputStream());
        }
        this.databaseConfig = (DatabaseConfig)ComponentContext.getBean((String)"databaseConfig");
        this.configuration.setProperties(this.databaseConfig.getHibernateProperties());
        return this.doExecute(context);
    }

    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-f [--config] file", "specify an alternate config file");
        options.put("-d [--data] dir", "use the specified directory for all pulse data");
        return options;
    }

    public boolean isDefault() {
        return false;
    }

    public abstract int doExecute(BootContext var1) throws IOException, ParseException;

    protected Options getSharedOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"data");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'d'));
        return options;
    }

    protected void processSharedOptions(CommandLine commandLine) {
        if (commandLine.hasOption('f')) {
            this.setConfig(commandLine.getOptionValue('f'));
        }
        if (commandLine.hasOption('d')) {
            this.setData(commandLine.getOptionValue('d'));
        }
    }

    public void parse(String ... argv) throws ParseException {
        Options options = this.getSharedOptions();
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(options, argv, true);
        this.processSharedOptions(commandLine);
    }
}

