/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting.demo;

import com.zutubi.pulse.charting.BuildResultsDataSource;
import com.zutubi.pulse.charting.DemoBuildResultDataSource;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoDataSourceFactory {
    private static final Random RAND = new Random();

    public static BuildResultsDataSource createBuildResultsDataSource() {
        return new DemoBuildResultDataSource(DemoDataSourceFactory.createBuildResults());
    }

    private static LinkedList<BuildResult> createBuildResults() {
        Calendar date = Calendar.getInstance();
        date.add(6, -35);
        LinkedList<BuildResult> buildResults = new LinkedList<BuildResult>();
        int l = 0;
        for (int i = 0; i < 35; ++i) {
            int j = RAND.nextInt(50);
            for (int k = 0; k < j; ++k) {
                boolean success = RAND.nextInt(50) < 40;
                long finished = date.getTimeInMillis();
                long started = finished - 1000L - (long)(RAND.nextInt(3000) + 200 * i);
                buildResults.add(DemoDataSourceFactory.createBuildResult(l++, success, started, finished));
            }
            date.add(6, 1);
        }
        return buildResults;
    }

    private static BuildResult createBuildResult(long id, boolean successful, long started, long finished) {
        BuildResult result = new BuildResult(null, null, null, id, false);
        result.setId(id);
        if (successful) {
            result.setState(ResultState.SUCCESS);
        } else {
            result.setState(ResultState.FAILURE);
        }
        result.getStamps().setStartTime(started);
        result.getStamps().setEndTime(finished);
        return result;
    }
}

