/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.BuildResultsDataSource;
import com.zutubi.pulse.charting.BuildResultsResultSet;
import com.zutubi.pulse.charting.DailyData;
import com.zutubi.pulse.charting.DailyDataHandler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.data.time.TimeTableXYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedChartData {
    private static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("d-MMM-yyyy");
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final int DEFAULT_TIMEFRAME = 30;
    private int timeframe = 30;
    private BuildResultsDataSource source;

    public int getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(int timeframe) {
        this.timeframe = timeframe;
    }

    public void setSource(BuildResultsDataSource source) {
        this.source = source;
    }

    public void populateDataSet(TimeTableXYDataset ds, DailyDataHandler handler) {
        Map<String, DailyData> map = this.aggregateData(this.source.getLastByDays(this.getTimeframe()));
        Calendar cal = Calendar.getInstance();
        cal.add(6, -this.timeframe);
        for (int i = 0; i <= this.timeframe; ++i) {
            Date date = cal.getTime();
            String key = this.getAggregateKey(date.getTime());
            handler.handle(date, map.get(key));
            cal.add(6, 1);
        }
    }

    private Map<String, DailyData> aggregateData(BuildResultsResultSet resultSet) {
        TreeMap<String, DailyData> map = new TreeMap<String, DailyData>();
        while (resultSet.next()) {
            String timestamp = this.getAggregateKey(resultSet.getEndTime());
            if (!map.containsKey(timestamp)) {
                map.put(timestamp, new DailyData(resultSet.getEndTime()));
            }
            DailyData a = (DailyData)map.get(timestamp);
            a.addBuild(resultSet);
        }
        return map;
    }

    private String getAggregateKey(long l) {
        CALENDAR.setTimeInMillis(l);
        return DATE_FMT.format(CALENDAR.getTime());
    }

    public double getLowerBound() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -this.timeframe);
        cal.add(6, -3);
        return cal.getTime().getTime();
    }

    public double getUpperBound() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 3);
        return cal.getTime().getTime();
    }
}

