/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.BuildResultsResultSet;
import com.zutubi.pulse.core.model.ResultState;

public class DailyData {
    private long time;
    private int successCount;
    private int failureCount;
    private long totalBuildTime;
    private double totalStageTime;
    private long totalTests;

    public DailyData(long time) {
        this.time = time;
    }

    public void addBuild(BuildResultsResultSet set) {
        if (set.getState() == ResultState.SUCCESS) {
            ++this.successCount;
            this.totalBuildTime += set.getElapsed() / 1000L;
            this.totalStageTime += set.getAverageStageTime() / 1000.0;
            this.totalTests += set.getTotalTests();
        } else {
            ++this.failureCount;
        }
    }

    public long getTime() {
        return this.time;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int getTotalCount() {
        return this.successCount + this.failureCount;
    }

    public double getAverageBuildTime() {
        if (this.successCount > 0) {
            return (double)this.totalBuildTime / (double)this.successCount;
        }
        return 0.0;
    }

    public double getAverageStageTime() {
        if (this.successCount > 0) {
            return this.totalStageTime / (double)this.successCount;
        }
        return 0.0;
    }

    public double getAverageTestCount() {
        if (this.successCount > 0) {
            return (double)this.totalTests / (double)this.successCount;
        }
        return 0.0;
    }
}

