/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.Chart;
import com.zutubi.pulse.charting.ChartColours;
import com.zutubi.pulse.charting.DailyData;
import com.zutubi.pulse.charting.DailyDataHandler;
import com.zutubi.pulse.charting.TimeBasedChartData;
import com.zutubi.pulse.i18n.Messages;
import java.awt.Paint;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildResultsChart
implements XYToolTipGenerator,
Chart {
    private String chartTitle = "chart.label";
    private String dateAxisLabel = "axis.domain.label";
    private String rangeAxisLabel = "axis.range.label";
    private String failureSeriesLabel = "series.failure.label";
    private String successSeriesLabel = "series.success.label";
    private String failureSeriesTooltip = "series.failure.tooltip";
    private String successSeriesTooltip = "series.success.tooltip";
    private TimeBasedChartData data;
    private static final Messages I18N = Messages.getInstance(BuildResultsChart.class);
    private boolean hasResults;

    public void setData(TimeBasedChartData data) {
        this.data = data;
    }

    public JFreeChart render() {
        TimeTableXYDataset ds = this.generateDataSet();
        StackedXYBarRenderer renderer = new StackedXYBarRenderer();
        renderer.setSeriesPaint(0, (Paint)ChartColours.FAILURE);
        renderer.setSeriesPaint(1, (Paint)ChartColours.SUCCESS);
        renderer.setToolTipGenerator((XYToolTipGenerator)this);
        DateAxis domainAxis = new DateAxis(I18N.format(this.dateAxisLabel));
        NumberAxis rangeAxis = new NumberAxis(I18N.format(this.rangeAxisLabel));
        if (!this.hasResults) {
            rangeAxis.setLowerBound(0.0);
        }
        XYPlot plot = new XYPlot((XYDataset)ds, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(I18N.format(this.chartTitle), (Plot)plot);
        chart.setBackgroundPaint((Paint)ChartColours.BACKGROUND);
        chart.setBorderVisible(false);
        return chart;
    }

    private TimeTableXYDataset generateDataSet() {
        final String failureSeries = I18N.format(this.failureSeriesLabel);
        final String successSeries = I18N.format(this.successSeriesLabel);
        final TimeTableXYDataset ds = new TimeTableXYDataset();
        this.data.populateDataSet(ds, new DailyDataHandler(){

            public void handle(Date date, DailyData data) {
                if (data == null) {
                    ds.add((TimePeriod)new Day(date), 0.0, failureSeries);
                    ds.add((TimePeriod)new Day(date), 0.0, successSeries);
                } else {
                    ds.add((TimePeriod)new Day(date), (double)data.getFailureCount(), failureSeries);
                    ds.add((TimePeriod)new Day(date), (double)data.getSuccessCount(), successSeries);
                    BuildResultsChart.this.hasResults = true;
                }
            }
        });
        return ds;
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        double value = dataset.getYValue(series, item);
        double total = dataset.getYValue(0, item) + dataset.getYValue(1, item);
        long p = Math.round((total != 0.0 ? value / total : 0.0) * 100.0);
        if (series == 0) {
            return String.format(I18N.format(this.failureSeriesTooltip), p);
        }
        return String.format(I18N.format(this.successSeriesTooltip), p);
    }
}

