/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap.freemarker;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.util.logging.Logger;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;

public class FreemarkerConfigurationFactoryBean
implements FactoryBean {
    private static final Logger LOG = Logger.getLogger(FreemarkerConfigurationFactoryBean.class);
    private static Configuration FREEMARKER_CONFIGURATION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        if (FREEMARKER_CONFIGURATION == null) {
            FreemarkerConfigurationFactoryBean freemarkerConfigurationFactoryBean = this;
            synchronized (freemarkerConfigurationFactoryBean) {
                if (FREEMARKER_CONFIGURATION == null) {
                    FREEMARKER_CONFIGURATION = new Configuration();
                    FREEMARKER_CONFIGURATION.setTemplateLoader(this.getMultiLoader());
                    FREEMARKER_CONFIGURATION.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
                    FREEMARKER_CONFIGURATION.addAutoInclude("macro.ftl");
                }
            }
        }
        return FREEMARKER_CONFIGURATION;
    }

    private TemplateLoader getMultiLoader() {
        MasterConfigurationManager manager = (MasterConfigurationManager)ComponentContext.getBean((String)"configurationManager");
        List templateRoots = manager.getSystemPaths().getTemplateRoots();
        File userTemplateRoot = manager.getUserPaths().getUserTemplateRoot();
        if (userTemplateRoot.isDirectory()) {
            templateRoots.add(0, userTemplateRoot);
        }
        FileTemplateLoader[] loaders = new FileTemplateLoader[templateRoots.size()];
        for (int i = 0; i < loaders.length; ++i) {
            try {
                loaders[i] = new FileTemplateLoader((File)templateRoots.get(i));
                continue;
            }
            catch (IOException e) {
                LOG.severe("Unable to add template root to freemarker configuration: " + e.getMessage(), (Throwable)e);
            }
        }
        return new MultiTemplateLoader((TemplateLoader[])loaders);
    }

    public Class getObjectType() {
        return Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

