/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.providers.XmlConfigurationProvider;
import com.zutubi.pulse.jetty.JettyManager;

public class WebManager {
    private JettyManager jettyManager;

    public void deployStartup() {
        this.ensureJettyStarted();
        this.loadXworkConfiguration("xwork-startup.xml");
    }

    public void deployShutdown() {
        this.ensureJettyStarted();
        this.loadXworkConfiguration("xwork-shutdown.xml");
    }

    public void deploySetup() {
        this.ensureJettyStarted();
        this.loadXworkConfiguration("xwork-setup.xml");
    }

    public void deployMain() {
        this.ensureJettyStarted();
        this.loadXworkConfiguration("xwork.xml");
    }

    private void loadXworkConfiguration(String name) {
        ConfigurationManager.clearConfigurationProviders();
        ConfigurationManager.addConfigurationProvider((ConfigurationProvider)new XmlConfigurationProvider(name));
        ConfigurationManager.getConfiguration().reload();
    }

    private void ensureJettyStarted() {
        if (!this.jettyManager.isStarted()) {
            this.jettyManager.start();
        }
    }

    public void setJettyManager(JettyManager jettyManager) {
        this.jettyManager = jettyManager;
    }
}

