/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.bootstrap.HSQLDBUtils;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.upgrade.tasks.SchemaRefactor;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class EmbeddedHSQLDBConsole
implements DatabaseConsole {
    private static final Logger LOG = Logger.getLogger(EmbeddedHSQLDBConsole.class);
    private DatabaseConfig databaseConfig;
    private DataSource dataSource;
    private MutableConfiguration hibernateConfig;
    private Properties hibernateProps;

    public EmbeddedHSQLDBConsole(DatabaseConfig config) {
        this.databaseConfig = config;
    }

    public boolean isEmbedded() {
        return true;
    }

    public boolean schemaExists() {
        return JDBCUtils.tableExists((DataSource)this.dataSource, (String)"RESOURCE");
    }

    public void createSchema() throws SQLException {
        try {
            JDBCUtils.execute((DataSource)this.dataSource, (String)"SET PROPERTY \"hsqldb.default_table_type\" 'cached'");
            JDBCUtils.execute((DataSource)this.dataSource, (String)"SET PROPERTY \"hsqldb.cache_file_scale\" 8");
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
        }
        SchemaRefactor refactor = new SchemaRefactor(this.hibernateConfig, this.hibernateProps);
        refactor.createSchema();
        try {
            JDBCUtils.execute((DataSource)this.dataSource, (String)"SET WRITE_DELAY 5");
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
        }
    }

    public void dropSchema() throws SQLException {
        SchemaRefactor refactor = new SchemaRefactor(this.hibernateConfig, this.hibernateProps);
        refactor.dropSchema();
    }

    public DatabaseConfig getConfig() {
        return this.databaseConfig;
    }

    public double getDatabaseUsagePercent() {
        return HSQLDBUtils.getDatabaseUsagePercent(this.dataSource);
    }

    public void stop(boolean force) {
        try {
            JDBCUtils.execute((DataSource)this.dataSource, (String)"SHUTDOWN COMPACT");
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setHibernateConfig(MutableConfiguration config) {
        this.hibernateConfig = config;
    }

    public void setHibernateProperties(Properties props) {
        this.hibernateProps = props;
    }
}

