/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.bootstrap.EmbeddedHSQLDBConsole;
import com.zutubi.pulse.bootstrap.RemoteDatabaseConsole;
import com.zutubi.pulse.upgrade.tasks.HackyConnectionProvider;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConsoleBeanFactory
implements FactoryBean {
    private DatabaseConsole instance;
    private DatabaseConfig databaseConfig;
    private DataSource dataSource;
    private List<String> mappings;

    public Object getObject() throws Exception {
        if (this.instance == null) {
            DatabaseConsole console;
            MutableConfiguration config = new MutableConfiguration();
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.databaseConfig.getProperties());
            props.put("hibernate.connection.provider_class", "com.zutubi.pulse.upgrade.tasks.HackyConnectionProvider");
            for (String mapping : this.mappings) {
                ClassPathResource r = new ClassPathResource(mapping);
                config.addInputStream(r.getInputStream());
            }
            HackyConnectionProvider.dataSource = this.dataSource;
            if (this.databaseConfig.getDriverClassName().contains(".hsqldb.")) {
                console = new EmbeddedHSQLDBConsole(this.databaseConfig);
                ((EmbeddedHSQLDBConsole)console).setDataSource(this.dataSource);
                ((EmbeddedHSQLDBConsole)console).setHibernateConfig(config);
                ((EmbeddedHSQLDBConsole)console).setHibernateProperties(props);
                this.instance = console;
            } else {
                console = new RemoteDatabaseConsole(this.databaseConfig);
                ((RemoteDatabaseConsole)console).setDataSource(this.dataSource);
                ((RemoteDatabaseConsole)console).setHibernateConfig(config);
                ((RemoteDatabaseConsole)console).setHibernateProperties(props);
                this.instance = console;
            }
        }
        return this.instance;
    }

    public Class getObjectType() {
        return DatabaseConsole.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseConfig(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    public void setHibernateMappings(List<String> mappings) {
        this.mappings = mappings;
    }
}

