/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.MasterUserPaths;
import java.util.Properties;

public class DatabaseConfig {
    protected static final String JDBC_DRIVER_CLASS_NAME = "jdbc.driverClassName";
    protected static final String JDBC_URL = "jdbc.url";
    protected static final String JDBC_USERNAME = "jdbc.username";
    protected static final String JDBC_PASSWORD = "jdbc.password";
    protected static final String JDBC_PROPERTY_PREFIX = "jdbc.property.";
    protected static final String HIBERNATE_PROPERTY_PREFIX = "hibernate.";
    private final Properties properties;
    private MasterUserPaths userPaths;

    public DatabaseConfig(Properties config) {
        this.properties = config;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getDriverClassName() {
        return this.properties.getProperty(JDBC_DRIVER_CLASS_NAME);
    }

    public String getUrl() {
        String url = this.properties.getProperty(JDBC_URL);
        if (url.contains("DB_ROOT") && this.userPaths != null) {
            url = url.replace("DB_ROOT", this.userPaths.getDatabaseRoot().getAbsolutePath());
        }
        return url;
    }

    public String getUsername() {
        return this.properties.getProperty(JDBC_USERNAME);
    }

    public String getPassword() {
        return this.properties.getProperty(JDBC_PASSWORD);
    }

    public Properties getConnectionProperties() {
        Properties props = new Properties();
        for (Object o : this.properties.keySet()) {
            String propertyName = (String)o;
            if (!propertyName.startsWith(JDBC_PROPERTY_PREFIX)) continue;
            String key = propertyName.substring(14);
            String value = this.properties.getProperty(propertyName);
            props.put(key, value);
        }
        return props;
    }

    public Properties getHibernateProperties() {
        Properties hibernateProperties = new Properties();
        for (Object o : this.properties.keySet()) {
            String propertyName = (String)o;
            if (!propertyName.startsWith(HIBERNATE_PROPERTY_PREFIX)) continue;
            String value = this.properties.getProperty(propertyName);
            hibernateProperties.put(propertyName, value);
        }
        return hibernateProperties;
    }

    public void setUserPaths(MasterUserPaths userPaths) {
        this.userPaths = userPaths;
    }
}

