/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.bootstrap.HSQLDBUtils;
import com.zutubi.pulse.bootstrap.MasterUserPaths;
import com.zutubi.pulse.bootstrap.StartupException;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.FileConfig;
import com.zutubi.pulse.transfer.TransferException;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

public class Data
implements MasterUserPaths {
    private static final Logger LOG = Logger.getLogger(Data.class);
    private final File pulseData;
    private Version dataVersion;
    private File userConfigRoot;
    private File projectRoot;
    private File userRoot;
    private File databaseRoot;
    private File userTemplateRoot;
    private File backupRoot;
    public static final String CONFIG_FILE_NAME = "pulse.config.properties";
    private Config config = null;
    private static final String LICENSE_KEY = "license.key";

    public Data(File dataDir) {
        this.pulseData = dataDir;
    }

    public boolean isInitialised() {
        return this.pulseData.exists() && this.getConfigFile().exists();
    }

    public void init(SystemPaths systemPaths) {
        if (this.isInitialised()) {
            throw new StartupException("Can not initialise a data directory that is already initialised.");
        }
        if (!this.pulseData.exists() && !this.pulseData.mkdirs()) {
            throw new StartupException("Failed to create the configured data directory: " + this.pulseData + ".");
        }
        Version systemVersion = Version.getVersion();
        this.updateVersion(systemVersion);
        this.transferExampleTemplates(systemPaths);
        this.transferDatabaseConfig(systemPaths);
    }

    public void backup(SystemPaths systemPaths) throws IOException, TransferException {
        String filename = String.format("auto-backup-%s.zip", this.getVersion().getVersionNumber());
        File backup = new File(this.getBackupRoot(), filename);
        if (backup.isFile() && !backup.delete()) {
            throw new IOException(String.format("Failed to remove previous backup '%s'. This file prevents a new backup from being generated.", backup.getAbsolutePath()));
        }
        File tmpBackup = new File(systemPaths.getTmpRoot(), filename);
        tmpBackup.mkdirs();
        DatabaseConsole databaseConsole = (DatabaseConsole)ComponentContext.getBean((String)"databaseConsole");
        if (databaseConsole.isEmbedded()) {
            HSQLDBUtils.compactDatabase((DataSource)ComponentContext.getBean((String)"dataSource"));
            File dest = new File(tmpBackup, "database");
            dest.mkdir();
            this.conditionalCopy(dest, new File(this.getDatabaseRoot(), "db.backup"));
            this.conditionalCopy(dest, new File(this.getDatabaseRoot(), "db.log"));
            this.conditionalCopy(dest, new File(this.getDatabaseRoot(), "db.properties"));
            this.conditionalCopy(dest, new File(this.getDatabaseRoot(), "db.data"));
            this.conditionalCopy(dest, new File(this.getDatabaseRoot(), "db.script"));
        }
        FileSystemUtils.copy((File)new File(tmpBackup, CONFIG_FILE_NAME), (File[])new File[]{this.getConfigFile()});
        FileSystemUtils.createZip((File)backup, (File)tmpBackup, (File)tmpBackup);
        FileSystemUtils.rmdir((File)tmpBackup);
    }

    private void conditionalCopy(File dest, File file) throws IOException {
        if (file.exists()) {
            FileSystemUtils.copy((File)dest, (File[])new File[]{file});
        }
    }

    public void restore() {
    }

    public void updateVersion(Version version) {
        this.getConfig().setProperty("build.date", version.getBuildDate());
        this.getConfig().setProperty("build.number", version.getBuildNumber());
        this.getConfig().setProperty("release.date", version.getReleaseDate());
        this.getConfig().setProperty("version.number", version.getVersionNumber());
    }

    public void transferExampleTemplates(SystemPaths systemPaths) {
        File userTemplateRoot = this.getUserTemplateRoot();
        if (!userTemplateRoot.isDirectory()) {
            if (!userTemplateRoot.getParentFile().isDirectory()) {
                userTemplateRoot.getParentFile().mkdirs();
            }
            List templateRoots = systemPaths.getTemplateRoots();
            for (File templateRoot : templateRoots) {
                File examplesDir = new File(templateRoot, "examples");
                if (!examplesDir.isDirectory()) continue;
                try {
                    FileSystemUtils.copy((File)userTemplateRoot, (File[])new File[]{examplesDir});
                    break;
                }
                catch (IOException e) {
                    LOG.warning("Unable to copy example templates to '" + userTemplateRoot.getAbsolutePath() + "'", (Throwable)e);
                }
            }
        }
    }

    private void transferDatabaseConfig(SystemPaths systemPaths) throws StartupException {
        try {
            File databaseConfig = new File(this.getUserConfigRoot(), "database.properties");
            if (!databaseConfig.exists()) {
                File databaseConfigTemplate = new File(systemPaths.getConfigRoot(), "database.properties.template");
                IOUtils.copyTemplate((File)databaseConfigTemplate, (File)databaseConfig);
            }
        }
        catch (IOException e) {
            throw new StartupException("Failed to create the database configuration file.", (Throwable)e);
        }
    }

    public int getBuildNumber() {
        return this.getVersion().getBuildNumberAsInt();
    }

    public void setBuildNumber(int i) {
        Config config = this.getConfig();
        config.setProperty("build.number", Integer.toString(i));
        this.dataVersion = null;
    }

    public Version getVersion() {
        if (this.dataVersion == null) {
            Properties prop = new Properties();
            prop.setProperty("build.date", this.getConfig().getProperty("build.date"));
            prop.setProperty("build.number", this.getConfig().getProperty("build.number"));
            prop.setProperty("release.date", this.getConfig().getProperty("release.date"));
            prop.setProperty("version.number", this.getConfig().getProperty("version.number"));
            this.dataVersion = Version.read((Properties)prop);
        }
        return this.dataVersion;
    }

    public String getLicenseKey() {
        return this.getConfig().getProperty(LICENSE_KEY);
    }

    public void setLicenseKey(String licenseKey) {
        this.getConfig().setProperty(LICENSE_KEY, licenseKey);
    }

    public File getData() {
        return this.pulseData;
    }

    public File getUserConfigRoot() {
        if (this.userConfigRoot == null) {
            this.userConfigRoot = new File(this.pulseData, "config");
        }
        return this.userConfigRoot;
    }

    public File getDatabaseRoot() {
        if (this.databaseRoot == null) {
            this.databaseRoot = new File(this.pulseData, "database");
        }
        return this.databaseRoot;
    }

    public File getProjectRoot() {
        if (this.projectRoot == null) {
            this.projectRoot = new File(this.pulseData, "projects");
        }
        return this.projectRoot;
    }

    public File getUserRoot() {
        if (this.userRoot == null) {
            this.userRoot = new File(this.pulseData, "users");
        }
        return this.userRoot;
    }

    public File getUserTemplateRoot() {
        if (this.userTemplateRoot == null) {
            this.userTemplateRoot = new File(this.getUserConfigRoot(), "templates");
        }
        return this.userTemplateRoot;
    }

    private Config getConfig() {
        if (this.config == null) {
            this.config = new FileConfig(this.getConfigFile());
        }
        return this.config;
    }

    public File getBackupRoot() {
        if (this.backupRoot == null) {
            this.backupRoot = new File(this.pulseData, "backups");
        }
        return this.backupRoot;
    }

    private File getConfigFile() {
        return new File(this.pulseData, CONFIG_FILE_NAME);
    }
}

