/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.agent;

import com.zutubi.pulse.BuildService;
import com.zutubi.pulse.MasterBuildService;
import com.zutubi.pulse.SystemInfo;
import com.zutubi.pulse.agent.Agent;
import com.zutubi.pulse.agent.Status;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.Startup;
import com.zutubi.pulse.bootstrap.StartupManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.logging.CustomLogRecord;
import com.zutubi.pulse.logging.ServerMessagesHandler;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterAgent
implements Agent {
    private MasterBuildService service;
    private MasterConfigurationManager configurationManager;
    private StartupManager startupManager;
    private ServerMessagesHandler serverMessagesHandler;

    public MasterAgent(MasterBuildService service, MasterConfigurationManager configurationManager, StartupManager startupManager, ServerMessagesHandler serverMessagesHandler) {
        this.service = service;
        this.configurationManager = configurationManager;
        this.startupManager = startupManager;
        this.serverMessagesHandler = serverMessagesHandler;
    }

    @Override
    public long getId() {
        return 0L;
    }

    @Override
    public BuildService getBuildService() {
        return this.service;
    }

    @Override
    public SystemInfo getSystemInfo() {
        return SystemInfo.getSystemInfo((ConfigurationManager)this.configurationManager, (Startup)this.startupManager);
    }

    @Override
    public List<CustomLogRecord> getRecentMessages() {
        return this.serverMessagesHandler.takeSnapshot();
    }

    @Override
    public boolean isOnline() {
        return this.isEnabled();
    }

    public boolean isEnabled() {
        MasterConfiguration masterConfig = this.configurationManager.getAppConfig();
        return masterConfig.isMasterEnabled();
    }

    @Override
    public Status getStatus() {
        if (!this.isEnabled()) {
            return Status.DISABLED;
        }
        if (this.service.getBuildingRecipe() == 0L) {
            return Status.IDLE;
        }
        return Status.BUILDING;
    }

    public void setStatus(Status status) {
        MasterConfiguration masterConfig = this.configurationManager.getAppConfig();
        if (status == Status.DISABLED) {
            masterConfig.setMasterEnabled(false);
        } else {
            masterConfig.setMasterEnabled(true);
        }
    }

    @Override
    public String getLocation() {
        SystemConfiguration systemConfig = this.configurationManager.getSystemConfig();
        return MasterAgent.constructMasterLocation(this.configurationManager.getAppConfig(), systemConfig);
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    public String getName() {
        return "master";
    }

    public static String constructMasterLocation(MasterConfiguration appConfig, SystemConfiguration systemConfig) {
        String url = appConfig.getAgentHost() + ":" + systemConfig.getServerPort() + systemConfig.getContextPath();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

