/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.agent;

import com.zutubi.pulse.MasterBuildService;
import com.zutubi.pulse.MasterRecipeProcessor;
import com.zutubi.pulse.SlaveBuildService;
import com.zutubi.pulse.SlaveProxyFactory;
import com.zutubi.pulse.Version;
import com.zutubi.pulse.agent.Agent;
import com.zutubi.pulse.agent.AgentManager;
import com.zutubi.pulse.agent.AgentUpdater;
import com.zutubi.pulse.agent.MasterAgent;
import com.zutubi.pulse.agent.SlaveAgent;
import com.zutubi.pulse.agent.Status;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.StartupManager;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.events.AgentStatusEvent;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.SlaveAgentRemovedEvent;
import com.zutubi.pulse.events.SlaveUpgradeCompleteEvent;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.license.LicenseManager;
import com.zutubi.pulse.license.authorisation.AddAgentAuthorisation;
import com.zutubi.pulse.logging.ServerMessagesHandler;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.services.SlaveService;
import com.zutubi.pulse.services.SlaveStatus;
import com.zutubi.pulse.services.UpgradeStatus;
import com.zutubi.pulse.util.logging.Logger;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAgentManager
implements AgentManager,
EventListener,
Stoppable {
    private static final Logger LOG = Logger.getLogger(DefaultAgentManager.class);
    private final int masterBuildNumber = Version.getVersion().getBuildNumberAsInt();
    private MasterAgent masterAgent;
    private ReentrantLock lock = new ReentrantLock();
    private Map<Long, SlaveAgent> slaveAgents;
    private SlaveManager slaveManager;
    private MasterRecipeProcessor masterRecipeProcessor;
    private MasterConfigurationManager configurationManager;
    private ResourceManager resourceManager;
    private EventManager eventManager;
    private SlaveProxyFactory slaveProxyFactory;
    private StartupManager startupManager;
    private ServerMessagesHandler serverMessagesHandler;
    private ServiceTokenManager serviceTokenManager;
    private LicenseManager licenseManager;
    private ExecutorService pingService = Executors.newCachedThreadPool();
    private Map<Long, AgentUpdater> updaters = new TreeMap<Long, AgentUpdater>();
    private ReentrantLock updatersLock = new ReentrantLock();
    private static final int PING_TIMEOUT = Integer.getInteger("pulse.agent.ping.timeout", 45);

    public void init() {
        MasterBuildService masterService = new MasterBuildService(this.masterRecipeProcessor, this.configurationManager, this.resourceManager);
        this.masterAgent = new MasterAgent(masterService, this.configurationManager, this.startupManager, this.serverMessagesHandler);
        this.refreshSlaveAgents();
        AddAgentAuthorisation addAgentAuthorisation = new AddAgentAuthorisation();
        addAgentAuthorisation.setAgentManager(this);
        this.licenseManager.addAuthorisation(addAgentAuthorisation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSlaveAgents() {
        this.lock.lock();
        try {
            this.slaveAgents = new TreeMap<Long, SlaveAgent>();
            for (Slave slave : this.slaveManager.getAll()) {
                this.addSlaveAgent(slave, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addSlaveAgent(Slave slave, boolean ping) {
        try {
            SlaveService service = this.slaveProxyFactory.createProxy(slave);
            SlaveBuildService buildService = new SlaveBuildService(service, this.serviceTokenManager, slave, this.configurationManager, this.resourceManager);
            if (slave.getEnableState() == Slave.EnableState.UPGRADING) {
                slave.setEnableState(Slave.EnableState.FAILED_UPGRADE);
                this.slaveManager.save(slave);
            }
            SlaveAgent agent = new SlaveAgent(slave, service, this.serviceTokenManager, buildService);
            this.slaveAgents.put(slave.getId(), agent);
            if (ping) {
                this.pingSlave(agent);
            }
        }
        catch (MalformedURLException e) {
            LOG.severe("Unable to contact slave '" + slave.getName() + "': " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pingSlaves() {
        ArrayList<SlaveAgent> copyOfSlaveAgents = null;
        this.lock.lock();
        try {
            copyOfSlaveAgents = new ArrayList<SlaveAgent>(this.slaveAgents.values());
        }
        finally {
            this.lock.unlock();
        }
        for (SlaveAgent agent : copyOfSlaveAgents) {
            this.pingSlave(agent);
        }
    }

    @Override
    public int getAgentCount() {
        return this.slaveAgents.size() + 1;
    }

    @Override
    public void addSlave(Slave slave) throws LicenseException {
        LicenseHolder.ensureAuthorization(AddAgentAuthorisation.AUTH);
        this.slaveManager.save(slave);
        this.slaveAdded(slave.getId());
    }

    @Override
    public void enableSlave(Slave slave) {
        this.setSlaveState(slave, Slave.EnableState.ENABLED);
    }

    @Override
    public void disableSlave(Slave slave) {
        this.setSlaveState(slave, Slave.EnableState.DISABLED);
    }

    @Override
    public void setSlaveState(Slave slave, Slave.EnableState state) {
        slave.setEnableState(state);
        this.slaveManager.save(slave);
        this.slaveChanged(slave.getId());
    }

    private void pingSlave(SlaveAgent agent) {
        if (agent.isEnabled()) {
            SlaveStatus status;
            Status oldStatus = agent.getStatus();
            FutureTask<SlaveStatus> future = new FutureTask<SlaveStatus>(new Pinger(agent));
            this.pingService.execute(future);
            try {
                status = future.get(PING_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                LOG.warning("Timed out pinging agent '" + agent.getName() + "'", (Throwable)e);
                status = new SlaveStatus(Status.OFFLINE, "Agent ping timed out");
            }
            catch (Exception e) {
                String message = "Unexpected error pinging agent '" + agent.getName() + "': " + e.getMessage();
                LOG.warning(message);
                LOG.debug((Throwable)e);
                status = new SlaveStatus(Status.OFFLINE, message);
            }
            agent.updateStatus(status);
            if (!oldStatus.isOnline() && status.getStatus().isOnline()) {
                try {
                    List resources = agent.getSlaveService().discoverResources(this.serviceTokenManager.getToken());
                    this.resourceManager.addDiscoveredResources(agent.getSlave(), resources);
                }
                catch (Exception e) {
                    LOG.warning("Unable to discover resource for agent '" + agent.getName() + "': " + e.getMessage(), (Throwable)e);
                }
            }
            if (oldStatus != agent.getStatus()) {
                this.eventManager.publish((Event)new AgentStatusEvent(this, oldStatus, agent));
                if (status.getStatus() == Status.VERSION_MISMATCH) {
                    this.updateAgent(agent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgent(SlaveAgent agent) {
        Slave slave = agent.getSlave();
        slave.setEnableState(Slave.EnableState.UPGRADING);
        this.slaveManager.save(slave);
        String masterUrl = "http://" + MasterAgent.constructMasterLocation(this.configurationManager.getAppConfig(), this.configurationManager.getSystemConfig());
        AgentUpdater updater = new AgentUpdater(agent, this.serviceTokenManager.getToken(), masterUrl, this.eventManager, this.configurationManager.getSystemPaths());
        this.updatersLock.lock();
        try {
            this.updaters.put(agent.getSlave().getId(), updater);
            updater.start();
        }
        finally {
            this.updatersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force) {
        if (force) {
            this.pingService.shutdownNow();
            this.updatersLock.lock();
            try {
                for (AgentUpdater updater : this.updaters.values()) {
                    updater.stop(force);
                }
            }
            finally {
                this.updatersLock.unlock();
            }
        } else {
            this.pingService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event evt) {
        SlaveUpgradeCompleteEvent suce = (SlaveUpgradeCompleteEvent)evt;
        Slave slave = suce.getSlaveAgent().getSlave();
        this.updatersLock.lock();
        try {
            this.updaters.remove(slave.getId());
        }
        finally {
            this.updatersLock.unlock();
        }
        if (suce.isSuccessful()) {
            suce.getSlaveAgent().setStatus(Status.OFFLINE);
            slave.setEnableState(Slave.EnableState.ENABLED);
            this.slaveManager.save(slave);
            this.pingSlave(suce.getSlaveAgent());
        } else {
            slave.setEnableState(Slave.EnableState.FAILED_UPGRADE);
            this.slaveManager.save(slave);
        }
    }

    public Class[] getHandledEvents() {
        return new Class[]{SlaveUpgradeCompleteEvent.class};
    }

    @Override
    public void enableMasterAgent() {
        if (this.masterAgent.isEnabled()) {
            return;
        }
        AgentStatusEvent statusEvent = new AgentStatusEvent(this, this.masterAgent.getStatus(), this.masterAgent);
        this.masterAgent.setStatus(Status.IDLE);
        this.eventManager.publish((Event)statusEvent);
    }

    @Override
    public void disableMasterAgent() {
        if (!this.masterAgent.isEnabled()) {
            return;
        }
        AgentStatusEvent statusEvent = new AgentStatusEvent(this, this.masterAgent.getStatus(), this.masterAgent);
        this.masterAgent.setStatus(Status.DISABLED);
        this.eventManager.publish((Event)statusEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Agent> getAllAgents() {
        this.lock.lock();
        try {
            LinkedList<Agent> result = new LinkedList<Agent>(this.slaveAgents.values());
            Collections.sort(result, new NamedEntityComparator());
            result.add(0, (SlaveAgent)((Object)this.masterAgent));
            LinkedList<Agent> linkedList = result;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Agent> getOnlineAgents() {
        this.lock.lock();
        try {
            LinkedList<Agent> online = new LinkedList<Agent>();
            if (this.masterAgent.isEnabled()) {
                online.add(this.masterAgent);
            }
            for (SlaveAgent a : this.slaveAgents.values()) {
                if (!a.isOnline()) continue;
                online.add(a);
            }
            LinkedList<Agent> linkedList = online;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Agent getAgent(Slave slave) {
        if (slave == null) {
            return this.masterAgent;
        }
        this.lock.lock();
        try {
            Agent agent = this.slaveAgents.get(slave.getId());
            return agent;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pingSlave(Slave slave) {
        this.pingSlave(this.slaveAgents.get(slave.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void slaveAdded(long id) {
        Slave slave = this.slaveManager.getSlave(id);
        if (slave != null) {
            this.lock.lock();
            try {
                this.addSlaveAgent(slave, true);
                this.licenseManager.refreshAuthorisations();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void slaveChanged(long id) {
        Slave slave = this.slaveManager.getSlave(id);
        if (slave != null) {
            this.lock.lock();
            try {
                this.removeSlaveAgent(id);
                this.addSlaveAgent(slave, true);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void slaveDeleted(long id) {
        this.lock.lock();
        try {
            this.removeSlaveAgent(id);
            this.licenseManager.refreshAuthorisations();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeStatus(UpgradeStatus upgradeStatus) {
        this.updatersLock.lock();
        try {
            AgentUpdater updater = this.updaters.get(upgradeStatus.getSlaveId());
            if (updater != null) {
                updater.upgradeStatus(upgradeStatus);
            } else {
                LOG.warning("Received upgrade status for agent that is not upgrading [" + upgradeStatus.getSlaveId() + "]");
            }
        }
        finally {
            this.updatersLock.unlock();
        }
    }

    @Override
    public boolean agentExists(String name) {
        return this.getAgent(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Agent getAgent(String name) {
        if (this.masterAgent.getName().equals(name)) {
            return this.masterAgent;
        }
        try {
            this.lock.lock();
            for (SlaveAgent s : this.slaveAgents.values()) {
                if (!s.getName().equals(name)) continue;
                SlaveAgent slaveAgent = s;
                return slaveAgent;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private void removeSlaveAgent(long id) {
        SlaveAgent agent = this.slaveAgents.remove(id);
        this.eventManager.publish((Event)new SlaveAgentRemovedEvent((Object)this, agent));
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setMasterRecipeProcessor(MasterRecipeProcessor masterRecipeProcessor) {
        this.masterRecipeProcessor = masterRecipeProcessor;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setSlaveProxyFactory(SlaveProxyFactory slaveProxyFactory) {
        this.slaveProxyFactory = slaveProxyFactory;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        eventManager.register((EventListener)this);
    }

    public void setStartupManager(StartupManager startupManager) {
        this.startupManager = startupManager;
    }

    public void setServerMessagesHandler(ServerMessagesHandler serverMessagesHandler) {
        this.serverMessagesHandler = serverMessagesHandler;
    }

    public void setServiceTokenManager(ServiceTokenManager serviceTokenManager) {
        this.serviceTokenManager = serviceTokenManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Pinger
    implements Callable<SlaveStatus> {
        private SlaveAgent agent;

        public Pinger(SlaveAgent agent) {
            this.agent = agent;
        }

        @Override
        public SlaveStatus call() throws Exception {
            SlaveStatus status;
            try {
                int build = this.agent.getSlaveService().ping();
                if (build == DefaultAgentManager.this.masterBuildNumber) {
                    String token = DefaultAgentManager.this.serviceTokenManager.getToken();
                    status = this.agent.getSlaveService().getStatus(token);
                } else {
                    status = new SlaveStatus(Status.VERSION_MISMATCH);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof ConnectException) {
                    status = new SlaveStatus(Status.OFFLINE, cause.getMessage());
                }
                LOG.warning("Exception pinging agent '" + this.agent.getName() + "': " + e.getMessage());
                LOG.debug((Throwable)e);
                status = new SlaveStatus(Status.OFFLINE, "Exception: '" + e.getClass().getName() + "'. Reason: " + e.getMessage());
            }
            status.setPingTime(System.currentTimeMillis());
            return status;
        }
    }
}

