/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.agent;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.agent.SlaveAgent;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.SlaveUpgradeCompleteEvent;
import com.zutubi.pulse.services.SlaveService;
import com.zutubi.pulse.services.UpgradeState;
import com.zutubi.pulse.services.UpgradeStatus;
import com.zutubi.pulse.servlet.DownloadPackageServlet;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class AgentUpdater
implements Runnable {
    private static final Logger LOG = Logger.getLogger(AgentUpdater.class);
    private SlaveAgent agent;
    private String token;
    private String masterUrl;
    private EventManager eventManager;
    private SystemPaths systemPaths;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private LinkedBlockingQueue<UpgradeStatus> statuses = new LinkedBlockingQueue();
    private long statusTimeout = 600L;
    private long rebootTimeout = 300L;
    private long pingInterval = 5000L;

    public AgentUpdater(SlaveAgent agent, String token, String masterUrl, EventManager eventManager, SystemPaths systemPaths) {
        this.agent = agent;
        this.token = token;
        this.masterUrl = masterUrl;
        this.eventManager = eventManager;
        this.systemPaths = systemPaths;
    }

    public void start() {
        this.executor.execute(this);
    }

    public void run() {
        SlaveService slaveService = this.agent.getSlaveService();
        File packageFile = DownloadPackageServlet.getAgentZip(this.systemPaths);
        String packageUrl = DownloadPackageServlet.getPackagesUrl(this.masterUrl) + "/" + packageFile.getName();
        String masterBuild = Version.getVersion().getBuildNumber();
        try {
            boolean accepted = slaveService.updateVersion(this.token, masterBuild, this.masterUrl, this.agent.getSlave().getId(), packageUrl, packageFile.length());
            if (!accepted) {
                this.agent.upgradeStatus(UpgradeState.FAILED, -1, "Agent rejected upgrade, manual upgrade required.");
                this.completed(false);
                return;
            }
            boolean rebooting = false;
            while (!rebooting) {
                UpgradeStatus status = this.statuses.poll(this.statusTimeout, TimeUnit.SECONDS);
                if (status == null) {
                    this.agent.upgradeStatus(UpgradeState.FAILED, -1, "Timed out waiting for message from agent.");
                    this.completed(false);
                    return;
                }
                this.agent.upgradeStatus(status.getState(), status.getProgress(), status.getMessage());
                switch (status.getState()) {
                    case ERROR: 
                    case FAILED: {
                        this.completed(false);
                        return;
                    }
                    case REBOOTING: {
                        rebooting = true;
                    }
                }
            }
            long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.rebootTimeout);
            int expectedBuild = Version.getVersion().getBuildNumberAsInt();
            while (System.currentTimeMillis() < endTime) {
                try {
                    int build = slaveService.ping();
                    if (build != expectedBuild) continue;
                    this.completed(true);
                    return;
                }
                catch (Exception e) {
                    Thread.sleep(this.pingInterval);
                }
            }
            this.agent.upgradeStatus(UpgradeState.FAILED, -1, "Timed out waiting for agent to reboot.");
            this.completed(false);
        }
        catch (Exception e) {
            LOG.warning((Throwable)e);
            this.agent.upgradeStatus(UpgradeState.ERROR, -1, e.getMessage());
            this.completed(false);
        }
    }

    private void completed(boolean succeeded) {
        this.eventManager.publish((Event)new SlaveUpgradeCompleteEvent(this, this.agent, succeeded));
    }

    public void stop(boolean force) {
        if (force) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
    }

    public void upgradeStatus(UpgradeStatus upgradeStatus) {
        this.statuses.add(upgradeStatus);
    }

    public void setStatusTimeout(long statusTimeout) {
        this.statusTimeout = statusTimeout;
    }

    public void setRebootTimeout(long rebootTimeout) {
        this.rebootTimeout = rebootTimeout;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }
}

