/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.BuildCompletedEvent;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.SubscriptionManager;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.renderer.BuildResultRenderer;
import com.zutubi.pulse.util.logging.Logger;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultNotifier
implements EventListener {
    public static final String FAILURE_LIMIT_PROPERTY = "pulse.notification.test.failure.limit";
    public static final int DEFAULT_FAILURE_LIMIT = 20;
    private static final Logger LOG = Logger.getLogger(ResultNotifier.class);
    private SubscriptionManager subscriptionManager;
    private UserManager userManager;
    private MasterConfigurationManager configurationManager;
    private BuildResultRenderer buildResultRenderer;
    private BuildManager buildManager;

    public static int getFailureLimit() {
        int limit = 20;
        String property = System.getProperty(FAILURE_LIMIT_PROPERTY);
        if (property != null) {
            try {
                limit = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                LOG.warning((Throwable)e);
            }
        }
        return limit;
    }

    public void handleEvent(Event evt) {
        BuildCompletedEvent event = (BuildCompletedEvent)evt;
        BuildResult buildResult = event.getResult();
        buildResult.loadFailedTestResults(this.configurationManager.getDataDirectory(), ResultNotifier.getFailureLimit());
        HashSet<String> notifiedContactPoints = new HashSet<String>();
        HashMap<String, String> renderCache = new HashMap<String, String>();
        List<Subscription> subscriptions = this.subscriptionManager.getSubscriptions(buildResult.getProject());
        for (Subscription subscription : subscriptions) {
            ContactPoint contactPoint = subscription.getContactPoint();
            if (notifiedContactPoints.contains(contactPoint.getUid())) continue;
            ComponentContext.autowire((Object)((Object)subscription));
            if (!subscription.conditionSatisfied(buildResult)) continue;
            String templateName = subscription.getTemplate();
            String rendered = this.renderResult(buildResult, templateName, renderCache);
            notifiedContactPoints.add(contactPoint.getUid());
            contactPoint.notify(buildResult, rendered, this.buildResultRenderer.getTemplateInfo(templateName, buildResult.isPersonal()).getMimeType());
            this.userManager.save(contactPoint);
        }
    }

    private String renderResult(BuildResult result, String template, Map<String, String> cache) {
        String rendered = cache.get(template);
        if (rendered == null) {
            StringWriter w = new StringWriter();
            this.buildResultRenderer.render(this.configurationManager.getAppConfig().getBaseUrl(), result, this.buildManager.getChangesForBuild(result), template, w);
            rendered = w.toString();
            cache.put(template, rendered);
        }
        return rendered;
    }

    public Class[] getHandledEvents() {
        return new Class[]{BuildCompletedEvent.class};
    }

    public void setEventManager(EventManager eventManager) {
        eventManager.register((EventListener)this);
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setBuildResultRenderer(BuildResultRenderer buildResultRenderer) {
        this.buildResultRenderer = buildResultRenderer;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }
}

