/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildService;
import com.zutubi.pulse.CopyBootstrapper;
import com.zutubi.pulse.RecipeDispatchRequest;
import com.zutubi.pulse.RecipeLogger;
import com.zutubi.pulse.RecipeQueue;
import com.zutubi.pulse.RecipeResultCollector;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.events.build.CommandCommencedEvent;
import com.zutubi.pulse.events.build.CommandCompletedEvent;
import com.zutubi.pulse.events.build.CommandOutputEvent;
import com.zutubi.pulse.events.build.RecipeCommencedEvent;
import com.zutubi.pulse.events.build.RecipeCompletedEvent;
import com.zutubi.pulse.events.build.RecipeDispatchedEvent;
import com.zutubi.pulse.events.build.RecipeErrorEvent;
import com.zutubi.pulse.events.build.RecipeEvent;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.util.logging.Logger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeController {
    private static final Logger LOG = Logger.getLogger(RecipeController.class);
    private BuildResult buildResult;
    private BuildSpecificationNode specNode;
    private RecipeResultNode recipeResultNode;
    private RecipeResult recipeResult;
    private RecipeDispatchRequest dispatchRequest;
    private List<ResourceProperty> buildProperties;
    private boolean personal;
    private boolean incremental;
    private RecipeResultNode previousSuccessful;
    private RecipeLogger logger;
    private RecipeResultCollector collector;
    private BuildManager buildManager;
    private ServiceTokenManager serviceTokenManager;
    private boolean finished = false;
    private RecipeQueue queue;
    private BuildService buildService;

    public RecipeController(BuildResult buildResult, BuildSpecificationNode specNode, RecipeResultNode recipeResultNode, RecipeDispatchRequest dispatchRequest, List<ResourceProperty> buildProperties, boolean personal, boolean incremental, RecipeResultNode previousSuccessful, RecipeLogger logger, RecipeResultCollector collector, RecipeQueue queue, BuildManager manager, ServiceTokenManager serviceTokenManager) {
        this.buildResult = buildResult;
        this.specNode = specNode;
        this.recipeResultNode = recipeResultNode;
        this.recipeResult = recipeResultNode.getResult();
        this.dispatchRequest = dispatchRequest;
        this.buildProperties = buildProperties;
        this.personal = personal;
        this.incremental = incremental;
        this.previousSuccessful = previousSuccessful;
        this.logger = logger;
        this.collector = collector;
        this.queue = queue;
        this.buildManager = manager;
        this.serviceTokenManager = serviceTokenManager;
    }

    public void prepare(BuildResult buildResult) {
        this.collector.prepare(buildResult, this.recipeResultNode.getResult().getId());
        this.logger.prepare();
    }

    public void initialise(Bootstrapper bootstrapper) {
        try {
            this.dispatchRequest.getRequest().setBootstrapper(bootstrapper);
            this.queue.enqueue(this.dispatchRequest);
        }
        catch (BuildException e) {
            this.handleBuildException(e);
        }
        catch (Exception e) {
            this.handleUnexpectedException(e);
        }
    }

    public boolean handleRecipeEvent(RecipeEvent event) {
        if (event.getRecipeId() != this.recipeResult.getId()) {
            return false;
        }
        try {
            if (event instanceof RecipeDispatchedEvent) {
                this.handleRecipeDispatch((RecipeDispatchedEvent)event);
            } else if (event instanceof RecipeCommencedEvent) {
                this.handleRecipeCommenced((RecipeCommencedEvent)event);
            } else if (event instanceof CommandCommencedEvent) {
                this.handleCommandCommenced((CommandCommencedEvent)event);
            } else if (event instanceof CommandOutputEvent) {
                this.handleCommandOutput((CommandOutputEvent)event);
            } else if (event instanceof CommandCompletedEvent) {
                this.handleCommandCompleted((CommandCompletedEvent)event);
            } else if (event instanceof RecipeCompletedEvent) {
                this.handleRecipeCompleted((RecipeCompletedEvent)event);
            } else if (event instanceof RecipeErrorEvent) {
                this.handleRecipeError((RecipeErrorEvent)event);
            }
        }
        catch (BuildException e) {
            this.handleBuildException(e);
        }
        catch (Exception e) {
            this.handleUnexpectedException(e);
        }
        return true;
    }

    private void handleRecipeDispatch(RecipeDispatchedEvent event) {
        this.logger.log(event);
        this.buildService = event.getAgent().getBuildService();
        this.recipeResultNode.setHost(this.buildService.getHostName());
        this.buildManager.save(this.recipeResultNode);
    }

    private void handleRecipeCommenced(RecipeCommencedEvent event) {
        RecipeResult result;
        this.recipeResult.commence(event.getName(), System.currentTimeMillis());
        if (this.previousSuccessful != null && (result = this.previousSuccessful.getResult()) != null) {
            this.recipeResult.getStamps().setEstimatedRunningTime(result.getStamps().getElapsed());
        }
        if (this.recipeResult.terminating()) {
            this.buildService.terminateRecipe(this.recipeResult.getId());
        }
        this.buildManager.save(this.recipeResult);
        this.logger.log(event, this.recipeResult);
    }

    private void handleCommandCommenced(CommandCommencedEvent event) {
        CommandResult previousCommand;
        RecipeResult previousResult;
        CommandResult result = new CommandResult(event.getName());
        if (this.previousSuccessful != null && (previousResult = this.previousSuccessful.getResult()) != null && (previousCommand = previousResult.getCommandResult(event.getName())) != null) {
            result.getStamps().setEstimatedRunningTime(previousCommand.getStamps().getElapsed());
        }
        result.commence(System.currentTimeMillis());
        this.recipeResult.add(result);
        this.buildManager.save(this.recipeResult);
        this.logger.log(event, result);
    }

    private void handleCommandOutput(CommandOutputEvent event) {
        this.logger.log(event);
    }

    private void handleCommandCompleted(CommandCompletedEvent event) {
        CommandResult result = event.getResult();
        result.getStamps().setEndTime(System.currentTimeMillis());
        this.recipeResult.update(result);
        this.buildManager.save(this.recipeResult);
        this.logger.log(event, result);
    }

    private void handleRecipeCompleted(RecipeCompletedEvent event) {
        RecipeResult result = event.getResult();
        result.getStamps().setEndTime(System.currentTimeMillis());
        this.recipeResult.update(event.getResult());
        this.logger.log(event, this.recipeResult);
        this.complete();
    }

    private void handleRecipeError(RecipeErrorEvent event) {
        this.recipeResult.error(event.getErrorMessage());
        this.logger.log(event, this.recipeResult);
        this.complete();
    }

    private void complete() {
        this.recipeResult.complete();
        this.recipeResult.abortUnfinishedCommands();
        if (!this.personal) {
            for (PostBuildAction action : this.specNode.getPostActions()) {
                ComponentContext.autowire((Object)((Object)action));
                action.execute(this.buildResult, this.recipeResultNode, this.buildProperties);
            }
        }
        this.buildManager.save(this.recipeResult);
        this.logger.complete(this.recipeResult);
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(BuildResult buildResult, boolean collectWorkingCopy) {
        try {
            this.logger.collecting(this.recipeResult, collectWorkingCopy);
            this.collector.collect(buildResult, this.recipeResult.getId(), collectWorkingCopy, this.incremental, this.buildService);
        }
        catch (BuildException e) {
            this.handleBuildException(e);
        }
        catch (Exception e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.logger.collectionComplete();
        }
    }

    public void cleanup(BuildResult buildResult) {
        try {
            this.collector.cleanup(buildResult, this.recipeResult.getId(), this.incremental, this.buildService);
        }
        catch (Exception e) {
            LOG.warning("Unable to clean up recipe '" + this.recipeResult.getId() + "'", (Throwable)e);
        }
    }

    public Bootstrapper getChildBootstrapper() {
        String url = this.buildService.getUrl();
        return new CopyBootstrapper(url, this.serviceTokenManager.getToken(), this.recipeResult.getId());
    }

    public String getRecipeName() {
        return this.recipeResultNode.getResult().getRecipeNameSafe();
    }

    public String getRecipeHost() {
        return this.recipeResultNode.getHostSafe();
    }

    private void handleBuildException(BuildException e) {
        this.recipeResult.error(e);
        this.complete();
    }

    private void handleUnexpectedException(Exception e) {
        LOG.severe((Throwable)e);
        this.recipeResult.error("Unexpected error: " + e.getMessage());
        this.complete();
    }

    public void terminateRecipe(boolean timeout) {
        if (this.recipeResult.commenced()) {
            this.recipeResult.terminate(timeout);
            this.buildService.terminateRecipe(this.recipeResult.getId());
        } else {
            this.recipeResult.terminate(timeout);
            if (this.queue.cancelRequest(this.recipeResult.getId())) {
                this.complete();
            }
        }
    }

    public RecipeDispatchRequest getDispatchRequest() {
        return this.dispatchRequest;
    }

    public RecipeResult getResult() {
        return this.recipeResult;
    }
}

