/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.BuildService;
import com.zutubi.pulse.MasterRecipeProcessor;
import com.zutubi.pulse.ServerRecipePaths;
import com.zutubi.pulse.agent.MasterAgent;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;

public class MasterBuildService
implements BuildService {
    private static final Logger LOG = Logger.getLogger(MasterBuildService.class);
    private MasterRecipeProcessor masterRecipeProcessor;
    private MasterConfigurationManager configurationManager;
    private ResourceManager resourceManager;

    public MasterBuildService(MasterRecipeProcessor masterRecipeProcessor, MasterConfigurationManager configurationManager, ResourceManager resourceManager) {
        this.masterRecipeProcessor = masterRecipeProcessor;
        this.configurationManager = configurationManager;
        this.resourceManager = resourceManager;
    }

    public String getUrl() {
        MasterConfiguration appConfig = this.configurationManager.getAppConfig();
        SystemConfiguration systemConfig = this.configurationManager.getSystemConfig();
        return MasterAgent.constructMasterLocation(appConfig, systemConfig);
    }

    public boolean hasResource(String resource, String version) {
        return this.resourceManager.getMasterRepository().hasResource(resource, version);
    }

    public boolean build(RecipeRequest request, BuildContext context) {
        this.masterRecipeProcessor.processRecipe(request, context);
        return true;
    }

    public long getBuildingRecipe() {
        return this.masterRecipeProcessor.getBuildingRecipe();
    }

    public void collectResults(String project, String spec, long recipeId, boolean incremental, File outputDest, File workDest) {
        ServerRecipePaths recipePaths = new ServerRecipePaths(project, spec, recipeId, this.configurationManager.getUserPaths().getData(), incremental);
        File outputDir = recipePaths.getOutputDir();
        if (!FileSystemUtils.rename((File)outputDir, (File)outputDest, (boolean)true)) {
            throw new BuildException("Unable to rename output directory '" + outputDir.getAbsolutePath() + "' to '" + outputDest.getAbsolutePath() + "'");
        }
        if (workDest != null) {
            File workDir = recipePaths.getBaseDir();
            if (incremental) {
                try {
                    FileSystemUtils.copy((File)workDest, (File[])new File[]{workDir});
                }
                catch (IOException e) {
                    throw new BuildException("Unable to snapshot work directory '" + workDir.getAbsolutePath() + "' to '" + workDest.getAbsolutePath() + "': " + e.getMessage());
                }
            } else if (!FileSystemUtils.rename((File)workDir, (File)workDest, (boolean)true)) {
                throw new BuildException("Unable to rename work directory '" + workDir.getAbsolutePath() + "' to '" + workDest.getAbsolutePath() + "'");
            }
        }
    }

    public void cleanup(String project, String spec, long recipeId, boolean incremental) {
        ServerRecipePaths recipePaths = new ServerRecipePaths(project, spec, recipeId, this.configurationManager.getUserPaths().getData(), incremental);
        File recipeRoot = recipePaths.getRecipeRoot();
        if (!FileSystemUtils.rmdir((File)recipeRoot)) {
            throw new BuildException("Unable to remove recipe directory '" + recipeRoot.getAbsolutePath() + "'");
        }
    }

    public void terminateRecipe(long recipeId) {
        this.masterRecipeProcessor.terminateRecipe(recipeId);
    }

    public String getHostName() {
        return "master";
    }

    public void setMasterRecipeProcessor(MasterRecipeProcessor masterRecipeProcessor) {
        this.masterRecipeProcessor = masterRecipeProcessor;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public boolean equals(Object obj) {
        return obj instanceof MasterBuildService;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

