/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import java.io.File;

public class MasterBuildPaths {
    private File projectRoot;
    private File userRoot;

    public MasterBuildPaths(MasterConfigurationManager configManager) {
        this.projectRoot = configManager.getUserPaths().getProjectRoot();
        this.userRoot = configManager.getUserPaths().getUserRoot();
    }

    public static String getEntityDirName(Entity entity) {
        return Long.toString(entity.getId());
    }

    public File getProjectDir(Project project) {
        return new File(this.projectRoot, MasterBuildPaths.getEntityDirName(project));
    }

    public File getUserDir(long userId) {
        return new File(this.userRoot, Long.toString(userId));
    }

    public File getRepoDir(Project project) {
        return new File(this.getProjectDir(project), "repo");
    }

    public File getBuildsDir(Project project) {
        return new File(this.getProjectDir(project), "builds");
    }

    public File getBuildsDir(long userId) {
        return new File(this.getUserDir(userId), "builds");
    }

    public static String getBuildDirName(BuildResult result) {
        return String.format("%08d", result.getNumber());
    }

    public File getBuildDir(BuildResult result) {
        File base = result.getUser() == null ? this.getProjectDir(result.getProject()) : this.getUserDir(result.getUser().getId());
        return new File(base, MasterBuildPaths.getBuildDirName(result));
    }

    public File getRecipeDir(BuildResult result, long recipeId) {
        return new File(this.getBuildDir(result), Long.toString(recipeId));
    }

    public File getOutputDir(BuildResult result, long recipeId) {
        return new File(this.getRecipeDir(result, recipeId), "output");
    }

    public File getBaseDir(BuildResult result, long recipeId) {
        return new File(this.getRecipeDir(result, recipeId), "base");
    }

    public File getUserPatchDir(long userId) {
        return new File(this.getUserDir(userId), "patches");
    }

    public File getUserPatchFile(long userId, long number) {
        return new File(this.getUserPatchDir(userId), String.format("%08d", number));
    }
}

