/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildController;
import com.zutubi.pulse.BuildQueue;
import com.zutubi.pulse.DefaultRecipeResultCollector;
import com.zutubi.pulse.RecipeQueue;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.events.AsynchronousDelegatingListener;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.AbstractBuildRequestEvent;
import com.zutubi.pulse.events.build.BuildCompletedEvent;
import com.zutubi.pulse.events.build.BuildTerminationRequestEvent;
import com.zutubi.pulse.events.build.RecipeTimeoutEvent;
import com.zutubi.pulse.license.LicenseEvent;
import com.zutubi.pulse.license.LicenseExpiredEvent;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.license.LicenseUpdateEvent;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.TestManager;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.scheduling.quartz.TimeoutRecipeJob;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.util.logging.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FatController
implements EventListener,
Stoppable {
    public static final String PARAM_EVENT_MANAGER = "eventManager";
    public static final String TIMEOUT_JOB_NAME = "build";
    public static final String TIMEOUT_JOB_GROUP = "timeout";
    private static final Logger LOG = Logger.getLogger(FatController.class);
    private EventManager eventManager;
    private AsynchronousDelegatingListener asyncListener;
    private BuildManager buildManager;
    private TestManager testManager;
    private MasterConfigurationManager configManager;
    private RecipeQueue recipeQueue;
    private ReentrantLock lock = new ReentrantLock();
    private Condition stoppedCondition = this.lock.newCondition();
    private boolean stopping = false;
    private BuildQueue buildQueue = new BuildQueue();
    private Set<BuildController> runningBuilds = new HashSet<BuildController>();
    private Scheduler quartzScheduler;
    private ProjectManager projectManager;
    private UserManager userManager;
    private ServiceTokenManager serviceTokenManager;
    private boolean enabled = false;

    public void init() throws SchedulerException {
        this.asyncListener = new AsynchronousDelegatingListener((EventListener)this);
        this.eventManager.register((EventListener)this.asyncListener);
        JobDetail detail = new JobDetail(TIMEOUT_JOB_NAME, TIMEOUT_JOB_GROUP, TimeoutRecipeJob.class);
        detail.getJobDataMap().put((Object)PARAM_EVENT_MANAGER, (Object)this.eventManager);
        detail.setDurability(true);
        this.quartzScheduler.addJob(detail, true);
        if (LicenseHolder.hasAuthorization("canRunPulse")) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    private void enable() {
        this.enabled = true;
    }

    private void disable() {
        this.enabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force) {
        this.lock.lock();
        try {
            this.stopping = true;
            if (force) {
                this.eventManager.publish((Event)new BuildTerminationRequestEvent(this, -1L, false));
            } else {
                LOG.info("Waiting for running builds to complete...");
                while (this.runningBuilds.size() > 0) {
                    try {
                        this.stoppedCondition.await();
                    }
                    catch (InterruptedException e) {
                        LOG.warning("Interrupted while waiting for running builds to complete", (Throwable)e);
                    }
                }
                LOG.info("All builds completed");
            }
        }
        finally {
            this.lock.unlock();
        }
        this.eventManager.unregister((EventListener)this.asyncListener);
        this.asyncListener.stop(force);
    }

    public void handleEvent(Event event) {
        if (event instanceof AbstractBuildRequestEvent) {
            this.handleBuildRequest((AbstractBuildRequestEvent)event);
        } else if (event instanceof BuildCompletedEvent) {
            this.handleBuildCompleted((BuildCompletedEvent)event);
        } else if (event instanceof LicenseEvent) {
            this.handleLicenseEvent((LicenseEvent)event);
        }
    }

    private void handleLicenseEvent(LicenseEvent event) {
        if (LicenseHolder.hasAuthorization("canRunPulse")) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void handleBuildRequest(AbstractBuildRequestEvent event) {
        if (this.isDisabled()) {
            return;
        }
        if (!event.isPersonal() && event.getProject().isPaused()) {
            return;
        }
        if (this.buildQueue.buildRequested(event)) {
            this.startBuild(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBuild(AbstractBuildRequestEvent event) {
        Project project = event.getProject();
        BuildSpecification buildSpec = event.getSpecification();
        this.lock.lock();
        try {
            if (!this.stopping) {
                if (!event.isPersonal()) {
                    this.projectManager.buildCommenced(project.getId());
                }
                DefaultRecipeResultCollector collector = new DefaultRecipeResultCollector(this.configManager);
                BuildController controller = new BuildController(event, buildSpec, this.eventManager, this.projectManager, this.userManager, this.buildManager, this.testManager, this.recipeQueue, collector, this.quartzScheduler, this.configManager, this.serviceTokenManager);
                controller.run();
                this.runningBuilds.add(controller);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void terminateBuild(long id, boolean timeout) {
        this.eventManager.publish((Event)new BuildTerminationRequestEvent(this, id, timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBuildCompleted(BuildCompletedEvent event) {
        this.lock.lock();
        try {
            Entity owner;
            AbstractBuildRequestEvent queuedEvent;
            BuildResult result = event.getResult();
            Project project = this.projectManager.getProject(result.getProject().getId());
            BuildController controller = (BuildController)event.getSource();
            this.runningBuilds.remove(controller);
            if (this.runningBuilds.size() == 0) {
                this.stoppedCondition.signalAll();
            }
            if (!result.isPersonal()) {
                this.projectManager.buildCompleted(project.getId());
            }
            if (!this.stopping && (queuedEvent = this.buildQueue.buildCompleted(owner = result.getOwner())) != null) {
                this.startBuild(queuedEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Class[] getHandledEvents() {
        return new Class[]{AbstractBuildRequestEvent.class, BuildCompletedEvent.class, RecipeTimeoutEvent.class, LicenseExpiredEvent.class, LicenseUpdateEvent.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Entity, List<AbstractBuildRequestEvent>> snapshotBuildQueue() {
        this.lock.lock();
        try {
            Map<Entity, List<AbstractBuildRequestEvent>> map = this.buildQueue.takeSnapshot();
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setRecipeQueue(RecipeQueue recipeQueue) {
        this.recipeQueue = recipeQueue;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setQuartzScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void setConfigurationManager(MasterConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setServiceTokenManager(ServiceTokenManager serviceTokenManager) {
        this.serviceTokenManager = serviceTokenManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public boolean cancelQueuedBuild(long id) {
        return this.buildQueue.cancelBuild(id);
    }

    public void setTestManager(TestManager testManager) {
        this.testManager = testManager;
    }
}

