/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.RecipeLogger;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.events.build.CommandCommencedEvent;
import com.zutubi.pulse.events.build.CommandCompletedEvent;
import com.zutubi.pulse.events.build.CommandOutputEvent;
import com.zutubi.pulse.events.build.RecipeCommencedEvent;
import com.zutubi.pulse.events.build.RecipeCompletedEvent;
import com.zutubi.pulse.events.build.RecipeDispatchedEvent;
import com.zutubi.pulse.events.build.RecipeErrorEvent;
import com.zutubi.pulse.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class DefaultRecipeLogger
implements RecipeLogger {
    private static final String PRE_RULE = "============================[ command output below ]============================";
    private static final String POST_RULE = "============================[ command output above ]============================";
    private static final DateFormat FORMAT = DateFormat.getDateTimeInstance(3, 1);
    private File logFile = null;
    private PrintWriter writer = null;

    public DefaultRecipeLogger(File logFile) {
        this.logFile = logFile;
    }

    public void prepare() {
        try {
            this.writer = new PrintWriter(this.logFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Unable to create recipe log file '" + this.logFile.getAbsolutePath() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public void log(RecipeDispatchedEvent event) {
        this.logMarker("Recipe dispatched to agent " + event.getAgent().getName(), System.currentTimeMillis());
    }

    public void log(RecipeCommencedEvent event, RecipeResult result) {
        this.logMarker("Recipe '" + result.getRecipeNameSafe() + "' commenced", result.getStamps().getStartTime());
    }

    public void log(CommandCommencedEvent event, CommandResult result) {
        this.logMarker("Command '" + result.getCommandName() + "' commenced", result.getStamps().getStartTime());
        if (this.writer != null) {
            this.writer.println(PRE_RULE);
            this.writer.flush();
        }
    }

    public void log(CommandOutputEvent event) {
        if (this.writer != null) {
            this.writer.print(new String(event.getData()));
            this.writer.flush();
        }
    }

    public void log(CommandCompletedEvent event, CommandResult result) {
        if (this.writer != null) {
            this.writer.println(POST_RULE);
            this.writer.flush();
        }
        this.logMarker("Command '" + result.getCommandName() + "' completed with status " + result.getState().getPrettyString(), result.getStamps().getEndTime());
    }

    public void log(RecipeCompletedEvent event, RecipeResult result) {
    }

    public void log(RecipeErrorEvent event, RecipeResult result) {
        this.logMarker("Recipe terminated with an error: " + event.getErrorMessage(), System.currentTimeMillis());
    }

    public void complete(RecipeResult result) {
        this.logMarker("Recipe '" + result.getRecipeNameSafe() + "' completed with status " + result.getState().getPrettyString(), result.getStamps().getEndTime());
    }

    public void collecting(RecipeResult recipeResult, boolean collectWorkingCopy) {
        this.logMarker("Collecting recipe artifacts" + (collectWorkingCopy ? " and working copy..." : "..."));
    }

    public void collectionComplete() {
        this.logMarker("Collection complete");
        IOUtils.close((Closeable)this.writer);
    }

    private void logMarker(String message) {
        this.logMarker(message, System.currentTimeMillis());
    }

    private void logMarker(String message, long time) {
        if (this.writer != null) {
            this.writer.print(FORMAT.format(new Date(time)));
            this.writer.print(": ");
            this.writer.println(message);
            this.writer.flush();
        }
    }
}

