/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import java.util.List;

public class BuildAborter
implements Runnable {
    private ProjectManager projectManager;
    private BuildManager buildManager;
    private UserManager userManager;
    private static final String ABORT_MESSAGE = "Server shut down while build in progress";

    public void run() {
        List<Project> projects = this.projectManager.getAllProjects();
        for (Project project : projects) {
            this.buildManager.abortUnfinishedBuilds(project, ABORT_MESSAGE);
            if (project.getState() != Project.State.BUILDING && project.getState() != Project.State.PAUSING) continue;
            this.projectManager.buildCompleted(project.getId());
        }
        List<User> users = this.userManager.getAllUsers();
        for (User user : users) {
            this.buildManager.abortUnfinishedBuilds(user, ABORT_MESSAGE);
        }
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

