/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.BorrowedConnectionProxy;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.transaction.CacheSynchronization;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JDBCContext
implements Serializable,
ConnectionManager.Callback {
    private static final Log log = LogFactory.getLog((Class)JDBCContext.class);
    private Context owner;
    private ConnectionManager connectionManager;
    private transient boolean isTransactionCallbackRegistered;
    private transient Transaction hibernateTransaction;

    public JDBCContext(Context owner, Connection connection, Interceptor interceptor) {
        boolean registerSynchronization;
        this.owner = owner;
        this.connectionManager = new ConnectionManager(owner.getFactory(), this, owner.getConnectionReleaseMode(), connection, interceptor);
        boolean bl = registerSynchronization = owner.isAutoCloseSessionEnabled() || owner.isFlushBeforeCompletionEnabled() || owner.getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION;
        if (registerSynchronization) {
            this.registerSynchronizationIfPossible();
        }
    }

    public void connectionOpened() {
        if (!this.isTransactionCallbackRegistered) {
            this.registerSynchronizationIfPossible();
        }
        if (this.owner.getFactory().getStatistics().isStatisticsEnabled()) {
            this.owner.getFactory().getStatisticsImplementor().connect();
        }
    }

    public void connectionCleanedUp() {
        if (!this.isTransactionCallbackRegistered) {
            this.afterTransactionCompletion(false, null);
        }
    }

    public SessionFactoryImplementor getFactory() {
        return this.owner.getFactory();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Connection userConnection() {
        if (this.getConnectionManager().isSuppliedConnection()) {
            return this.connection();
        }
        return BorrowedConnectionProxy.generateProxy(this);
    }

    public Connection connection() throws HibernateException {
        if (!this.owner.isOpen()) {
            throw new SessionException("Session is closed");
        }
        return this.connectionManager.getConnection();
    }

    public boolean registerCallbackIfNecessary() {
        if (this.isTransactionCallbackRegistered) {
            return false;
        }
        this.isTransactionCallbackRegistered = true;
        return true;
    }

    public boolean registerSynchronizationIfPossible() {
        if (this.isTransactionCallbackRegistered) {
            return true;
        }
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            javax.transaction.Transaction tx = tm.getTransaction();
            if (JTAHelper.isTransactionInProgress(tx)) {
                tx.registerSynchronization((Synchronization)new CacheSynchronization(this.owner, this, tx, null));
                this.isTransactionCallbackRegistered = true;
                log.debug((Object)"successfully registered Synchronization");
                return true;
            }
            log.debug((Object)"no active transaction, could not register Synchronization");
            return false;
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization with JTA TransactionManager", e);
        }
    }

    public boolean isTransactionInProgress() {
        boolean isHibernateTransactionActive = this.hibernateTransaction != null && this.hibernateTransaction.isActive();
        return isHibernateTransactionActive || JTAHelper.isTransactionInProgress(this.owner.getFactory());
    }

    public Transaction getTransaction() throws HibernateException {
        if (this.hibernateTransaction == null) {
            this.hibernateTransaction = this.owner.getFactory().getSettings().getTransactionFactory().createTransaction(this, this.owner);
        }
        return this.hibernateTransaction;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace((Object)"before transaction completion");
        this.owner.beforeTransactionCompletion(tx);
    }

    public void afterTransactionBegin(Transaction tx) {
        log.trace((Object)"after transaction begin");
        this.owner.afterTransactionBegin(tx);
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace((Object)"after transaction completion");
        if (this.getFactory().getStatistics().isStatisticsEnabled()) {
            this.getFactory().getStatisticsImplementor().endTransaction(success);
        }
        this.connectionManager.afterTransaction();
        this.isTransactionCallbackRegistered = false;
        this.hibernateTransaction = null;
        this.owner.afterTransactionCompletion(success, tx);
    }

    public void afterNontransactionalQuery(boolean success) {
        log.trace((Object)"after autocommit");
        try {
            boolean isAutocommit = this.connectionManager.isAutoCommit();
            this.connectionManager.afterTransaction();
            if (isAutocommit) {
                this.owner.afterTransactionCompletion(success, null);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.owner.getFactory().getSQLExceptionConverter(), sqle, "could not inspect JDBC autocommit mode");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        boolean deserHasCallbackRegistered = this.isTransactionCallbackRegistered && !this.owner.getFactory().getSettings().getTransactionFactory().areCallbacksLocalToHibernateTransactions();
        oos.writeBoolean(deserHasCallbackRegistered);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.isTransactionCallbackRegistered = ois.readBoolean();
    }

    public static interface Context
    extends TransactionFactory.Context {
        public void afterTransactionBegin(Transaction var1);

        public void beforeTransactionCompletion(Transaction var1);

        public void afterTransactionCompletion(boolean var1, Transaction var2);

        public ConnectionReleaseMode getConnectionReleaseMode();

        public boolean isAutoCloseSessionEnabled();
    }
}

