/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import org.hibernate.Hibernate;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.type.Type;

public class BinaryLogicOperatorNode
extends SqlNode
implements BinaryOperatorNode {
    public void initialize() throws SemanticException {
        Node lhs = this.getLeftHandOperand();
        if (lhs == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        Node rhs = this.getRightHandOperand();
        if (rhs == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        if (ParameterNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass()) && SqlNode.class.isAssignableFrom(((Object)((Object)rhs)).getClass())) {
            ((ParameterNode)lhs).getHqlParameterSpecification().setExpectedType(((SqlNode)rhs).getDataType());
        } else if (ParameterNode.class.isAssignableFrom(((Object)((Object)rhs)).getClass()) && SqlNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass())) {
            ((ParameterNode)rhs).getHqlParameterSpecification().setExpectedType(((SqlNode)lhs).getDataType());
        }
    }

    public Type getDataType() {
        return Hibernate.BOOLEAN;
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }
}

