/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation.validators;

import com.zutubi.validation.FieldValidator;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.validators.ValidatorSupport;

public abstract class FieldValidatorSupport
extends ValidatorSupport
implements FieldValidator {
    private String fieldName;
    private ValidationContext context;
    private String defaultMessage;
    private String messageKey;
    private String defaultMessageKey;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    protected Object[] getMessageArgs() {
        return new Object[]{this.getFieldName()};
    }

    protected String getMessage() {
        String message;
        if (this.messageKey != null) {
            this.messageKey = this.messageKey.replace("${fieldName}", this.getFieldName());
            message = this.validationContext.getText(this.messageKey, this.getMessageArgs());
            if (message == null) {
                message = this.determineDefaultMessage();
            }
        } else {
            message = this.determineDefaultMessage();
        }
        if (message == null) {
            message = "no.message.available";
        }
        return message;
    }

    private String determineDefaultMessage() {
        if (this.defaultMessage != null) {
            return this.defaultMessage;
        }
        if (this.defaultMessageKey != null) {
            this.defaultMessageKey = this.defaultMessageKey.replace("${fieldName}", this.getFieldName());
            this.defaultMessage = this.validationContext.getText(this.defaultMessageKey, this.getMessageArgs());
        }
        if (this.defaultMessage == null) {
            this.defaultMessage = this.messageKey;
        }
        return this.defaultMessage;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    protected void setDefaultMessageKey(String messageKey) {
        this.defaultMessageKey = messageKey;
    }

    protected void addFieldError(String fieldName) {
        this.validationContext.addFieldError(fieldName, this.getMessage());
    }

    protected void addActionError() {
        this.validationContext.addActionError(this.getMessage());
    }
}

