/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation;

import com.zutubi.validation.ValidationAware;
import com.zutubi.validation.ValidationAwareSupport;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.XWorkValidationAdapter;
import com.zutubi.validation.i18n.DefaultTextProvider;
import com.zutubi.validation.i18n.TextProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingValidationContext
implements ValidationContext {
    protected ValidationAware validationAware;
    protected TextProvider textProvider;

    public DelegatingValidationContext(ValidationAware validationAware, TextProvider textProvider) {
        this.validationAware = validationAware;
        this.textProvider = textProvider;
    }

    public DelegatingValidationContext(Object obj) {
        this.validationAware = this.makeValidationAware(obj);
        this.textProvider = this.makeTextPovider(obj);
    }

    protected DelegatingValidationContext() {
    }

    public TextProvider makeTextPovider(Object obj) {
        if (obj instanceof TextProvider) {
            return ((TextProvider)obj).getTextProvider(obj);
        }
        return new DefaultTextProvider();
    }

    public ValidationAware makeValidationAware(Object o) {
        if (o instanceof ValidationAware) {
            return (ValidationAware)o;
        }
        if (o instanceof com.opensymphony.xwork.ValidationAware) {
            return new XWorkValidationAdapter((com.opensymphony.xwork.ValidationAware)o);
        }
        return new ValidationAwareSupport();
    }

    @Override
    public TextProvider getTextProvider(Object context) {
        return this.textProvider.getTextProvider(context);
    }

    @Override
    public void addActionError(String error) {
        this.validationAware.addActionError(error);
    }

    @Override
    public void addFieldError(String field, String error) {
        this.validationAware.addFieldError(field, error);
    }

    @Override
    public Collection<String> getActionErrors() {
        return this.validationAware.getActionErrors();
    }

    @Override
    public List<String> getFieldErrors(String field) {
        return this.validationAware.getFieldErrors(field);
    }

    @Override
    public boolean hasErrors() {
        return this.validationAware.hasErrors();
    }

    @Override
    public boolean hasFieldErrors() {
        return this.validationAware.hasFieldErrors();
    }

    @Override
    public boolean hasActionErrors() {
        return this.validationAware.hasActionErrors();
    }

    @Override
    public boolean hasFieldError(String field) {
        return this.validationAware.hasFieldError(field);
    }

    public Map getFieldErrors() {
        return this.validationAware.getFieldErrors();
    }

    @Override
    public void addActionMessage(String message) {
        this.validationAware.addActionMessage(message);
    }

    @Override
    public Collection<String> getActionMessages() {
        return this.validationAware.getActionMessages();
    }

    @Override
    public boolean hasActionMessages() {
        return this.validationAware.hasActionMessages();
    }

    @Override
    public void setActionMessages(Collection<String> messages) {
        this.validationAware.setActionMessages(messages);
    }

    @Override
    public void setActionErrors(Collection<String> errors) {
        this.validationAware.setActionErrors(errors);
    }

    @Override
    public void setFieldErrors(Map<String, List<String>> errors) {
        this.validationAware.setFieldErrors(errors);
    }

    @Override
    public String getText(String key) {
        return this.textProvider.getText(key);
    }

    @Override
    public String getText(String key, String defaultValue) {
        return this.textProvider.getText(key, defaultValue);
    }

    @Override
    public String getText(String key, Object ... args) {
        return this.textProvider.getText(key, args);
    }

    @Override
    public String getText(String key, String defaultValue, Object ... args) {
        return this.textProvider.getText(key, defaultValue, args);
    }

    @Override
    public String getFullFieldName(String fieldName) {
        return fieldName;
    }
}

