/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation;

import com.zutubi.validation.FieldValidator;
import com.zutubi.validation.ShortCircuitableValidator;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.ValidationException;
import com.zutubi.validation.ValidationManager;
import com.zutubi.validation.Validator;
import com.zutubi.validation.ValidatorProvider;
import com.zutubi.validation.validators.DelegateValidator;
import com.zutubi.validation.validators.ValidateableValidator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationManager
implements ValidationManager {
    private List<ValidatorProvider> providers = new LinkedList<ValidatorProvider>();

    @Override
    public void validate(Object o, ValidationContext context) throws ValidationException {
        this.verify(this.providers);
        LinkedList<Validator> validators = new LinkedList<Validator>();
        for (ValidatorProvider provider : this.providers) {
            validators.addAll(provider.getValidators(o));
        }
        for (Validator v : validators) {
            FieldValidator vf;
            if (v instanceof FieldValidator && context.hasFieldError((vf = (FieldValidator)v).getFieldName()) && v instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)((Object)v)).isShortCircuit()) continue;
            if (v instanceof DelegateValidator) {
                ((DelegateValidator)v).setValidationManager(this);
            }
            if (v instanceof ValidateableValidator && context.hasErrors() && ((ShortCircuitableValidator)((Object)v)).isShortCircuit()) continue;
            v.setValidationContext(context);
            v.validate(o);
        }
    }

    private void verify(List<ValidatorProvider> providers) throws IllegalArgumentException {
        if (providers == null || providers.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public void setProviders(List<ValidatorProvider> providers) {
        this.verify(providers);
        this.providers = providers;
    }

    public void addValidatorProvider(ValidatorProvider provider) {
        this.providers.add(provider);
    }
}

