/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemUtils {
    private static final Logger LOG = Logger.getLogger(SystemUtils.class);
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("win");
    public static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    public static final String LINE_SEPARATOR;
    public static final byte[] LINE_SEPARATOR_BYTES;
    public static final byte[] CR_BYTES;
    public static final byte[] CRLF_BYTES;
    public static final byte[] LF_BYTES;

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static File findInPath(String name) {
        return SystemUtils.findInPath(name, null);
    }

    public static String runCommand(String ... command) throws IOException {
        Process process = Runtime.getRuntime().exec(command);
        InputStreamReader stdoutReader = new InputStreamReader(process.getInputStream());
        StringWriter stdoutWriter = new StringWriter();
        IOUtils.joinReaderToWriter(stdoutReader, stdoutWriter);
        int exitCode = 0;
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException e) {
            LOG.warning(e);
        }
        if (exitCode == 0) {
            return stdoutWriter.getBuffer().toString();
        }
        throw new IOException(String.format("Command '%s' exited with code %d", command[0], exitCode));
    }

    public static File findInPath(String name, Collection<String> extraPaths) {
        String path;
        LinkedList<String> allPaths = new LinkedList<String>();
        if (extraPaths != null) {
            allPaths.addAll(extraPaths);
        }
        if ((path = System.getenv("PATH")) != null) {
            String[] paths = path.split(File.pathSeparator);
            allPaths.addAll(Arrays.asList(paths));
        }
        if (IS_WINDOWS) {
            return SystemUtils.findInWindowsPaths(allPaths, name);
        }
        return SystemUtils.findInPaths(allPaths, name);
    }

    private static File findInPaths(List<String> paths, String name) {
        for (String dir : paths) {
            File test = new File(dir, name);
            if (!test.isFile()) continue;
            return test;
        }
        return null;
    }

    private static File findInWindowsPaths(List<String> paths, String name) {
        String[] extensions;
        name = name.toUpperCase();
        String pathext = System.getenv("PATHEXT");
        if (pathext == null) {
            extensions = new String[]{".COM", ".EXE", ".BAT", ".CMD", ".VBS", ".VBE", ".JS", ".JSE", ".WSF", ".WSH"};
        } else {
            extensions = pathext.split(";");
            for (int i = 0; i < extensions.length; ++i) {
                extensions[i] = extensions[i].toUpperCase();
            }
        }
        for (String p : paths) {
            String[] list;
            File dir = new File(p);
            if (!dir.isDirectory()) continue;
            for (String filename : list = dir.list()) {
                File candidate = new File(dir, filename);
                if (!candidate.isFile() || !SystemUtils.filenameMatches(name, filename, extensions)) continue;
                return candidate;
            }
        }
        return null;
    }

    private static boolean filenameMatches(String name, String filename, String[] extensions) {
        filename = filename.toUpperCase();
        for (String extension : extensions) {
            if (!filename.equals(name + extension)) continue;
            return true;
        }
        return false;
    }

    static {
        CR_BYTES = new byte[]{13};
        CRLF_BYTES = new byte[]{13, 10};
        LF_BYTES = new byte[]{10};
        String sep = System.getProperty("line.separator");
        if (sep == null) {
            sep = IS_WINDOWS ? "\r\n" : "\n";
        }
        LINE_SEPARATOR = sep;
        LINE_SEPARATOR_BYTES = LINE_SEPARATOR.getBytes();
    }
}

