/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipFile;

public class IOUtils {
    private static final Logger LOG = Logger.getLogger(IOUtils.class);

    public static Properties read(File f) throws IOException {
        return IOUtils.read(new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties read(InputStream input) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOUtils.close(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Properties properties, File dest) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            properties.store(out, "");
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOG.finest(e);
        }
    }

    public static void close(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException e) {
            LOG.finest(e);
        }
    }

    public static void joinStreams(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[1024];
        while (!Thread.interrupted() && (n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
    }

    public static void joinStreams(InputStream input, OutputStream output, boolean close) throws IOException {
        IOUtils.joinStreams(input, output);
        if (close) {
            IOUtils.close(input);
            IOUtils.close(output);
        }
    }

    public static void joinReaderToWriter(Reader reader, Writer writer) throws IOException {
        int n;
        char[] buffer = new char[1024];
        while ((n = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File fromFile, File toFile) throws IOException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(fromFile);
            outStream = new FileOutputStream(toFile);
            IOUtils.joinStreams(inStream, outStream);
        }
        catch (Throwable throwable) {
            IOUtils.close(inStream);
            IOUtils.close(outStream);
            throw throwable;
        }
        IOUtils.close(inStream);
        IOUtils.close(outStream);
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.joinStreams(is, os);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(File file) throws IOException {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            string = IOUtils.inputStreamToString(is);
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new FileInputStream(file);
            os = new ByteArrayOutputStream((int)file.length());
            IOUtils.joinStreams(is, os);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(is);
        IOUtils.close(os);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL url, File destination) throws IOException {
        FileOutputStream fos = null;
        InputStream urlStream = null;
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            int code = urlConnection.getResponseCode();
            if (code != 200) {
                String error = "Host returned code " + Integer.toString(code);
                String message = urlConnection.getResponseMessage();
                if (message != null) {
                    error = error + ": " + message;
                }
                throw new IOException(error);
            }
            fos = new FileOutputStream(destination);
            urlStream = urlConnection.getInputStream();
            IOUtils.joinStreams(urlStream, fos);
        }
        catch (Throwable throwable) {
            IOUtils.close(urlStream);
            IOUtils.close(fos);
            throw throwable;
        }
        IOUtils.close(urlStream);
        IOUtils.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTemplate(File template, File destination) throws IOException {
        File parentFile = destination.getParentFile();
        if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create parent directory '" + parentFile.getAbsolutePath() + "' for config file");
        }
        if (!destination.createNewFile()) {
            throw new IOException("Unable to create config file '" + destination.getAbsolutePath() + "'");
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(template));
            writer = new BufferedWriter(new FileWriter(destination));
            boolean doneSkipping = false;
            while ((line = reader.readLine()) != null) {
                if (!doneSkipping && line.startsWith("###")) continue;
                doneSkipping = true;
                writer.write(line);
                writer.write(10);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close(reader);
        IOUtils.close(writer);
    }
}

