/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.util.SystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileSystemUtils {
    private static final Logger LOG = Logger.getLogger(FileSystemUtils.class);
    public static final char ZIP_SEPARATOR = '/';
    public static final int PERMISSION_OWNER_READ = 256;
    public static final int PERMISSION_OWNER_WRITE = 128;
    public static final int PERMISSION_OWNER_EXECUTE = 64;
    public static final int PERMISSION_GROUP_READ = 32;
    public static final int PERMISSION_GROUP_WRITE = 16;
    public static final int PERMISSION_GROUP_EXECUTE = 8;
    public static final int PERMISSION_OTHER_READ = 4;
    public static final int PERMISSION_OTHER_WRITE = 2;
    public static final int PERMISSION_OTHER_EXECUTE = 1;
    public static final int PERMISSION_OWNER_FULL = 448;
    public static final int PERMISSION_GROUP_FULL = 56;
    public static final int PERMISSION_OTHER_FULL = 7;
    public static final int PERMISSION_ALL_READ = 292;
    public static final int PERMISSION_ALL_WRITE = 146;
    public static final int PERMISSION_ALL_EXECUTE = 73;
    public static final int PERMISSION_ALL_FULL = 511;
    static final boolean USE_UNIX_COPY = !SystemUtils.IS_WINDOWS && SystemUtils.findInPath("cp") != null;
    static final boolean LN_AVAILABLE = !SystemUtils.IS_WINDOWS && SystemUtils.findInPath("ln") != null;
    static final boolean STAT_AVAILABLE = !SystemUtils.IS_WINDOWS && SystemUtils.findInPath("stat") != null;

    public static boolean rmdir(File dir) {
        String canonicalDir;
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (dir.isFile()) {
            throw new IllegalArgumentException(String.format("removeDirectory can only be used on directories. %s is not a directory.", dir));
        }
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            canonicalDir = dir.getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        String[] contents = dir.list();
        if (contents != null) {
            for (String child : contents) {
                String canonicalFile;
                File file = new File(dir, child);
                try {
                    canonicalFile = file.getCanonicalPath();
                }
                catch (IOException e) {
                    return false;
                }
                if (!(file.isDirectory() && canonicalFile.startsWith(canonicalDir) ? !FileSystemUtils.rmdir(file) : !file.delete())) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void cleanOutputDir(File output) throws IOException {
        if (output.isDirectory() && !FileSystemUtils.rmdir(output)) {
            throw new IOException("Unable to remove existing output directory '" + output.getPath() + "'");
        }
        if (!output.mkdirs()) {
            throw new IOException("Unable to create output directory '" + output.getPath() + "'");
        }
    }

    public static File createTempDir() throws IOException {
        return FileSystemUtils.createTempDir("dir", null);
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        return FileSystemUtils.createTempDir(prefix, suffix, null);
    }

    public static File createTempDir(String prefix, String suffix, File base) throws IOException {
        if (base != null && !base.exists() && !base.mkdirs()) {
            throw new IOException("Failed to create temporary directory. Base directory does not exist: " + base.getAbsolutePath());
        }
        File file = File.createTempFile(prefix, suffix, base);
        if (!file.exists()) {
            throw new IOException("Failed to create temporary directory. Reason: File.createTempFile failed.");
        }
        if (!file.delete()) {
            throw new IOException("Failed to create temporary directory. Reason: tmpFile.delete failed.");
        }
        if (!file.mkdirs()) {
            throw new IOException("Failed to create temporary directory. Reason: tmpDir.mkdirs failed.");
        }
        return file;
    }

    public static void createDirectory(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException(String.format("Can not create directory. File '%s' already exists.", file));
            }
            return;
        }
        if (!file.mkdirs()) {
            throw new IOException(String.format("Failed to create directory '%s'", file));
        }
    }

    public static boolean isParentOf(File parent, File child) throws IOException {
        String parentPath = parent.getCanonicalPath();
        String childPath = child.getCanonicalPath();
        return childPath.startsWith(parentPath);
    }

    public static boolean isSymlink(File file) {
        File parent;
        if (!SystemUtils.IS_WINDOWS && (parent = file.getParentFile()) != null) {
            try {
                String parentCanonical = parent.getCanonicalPath() + "/";
                String fileCanonical = file.getCanonicalPath();
                if (fileCanonical.startsWith(parentCanonical)) {
                    String canonicalName = fileCanonical.substring(parentCanonical.length());
                    return !canonicalName.equals(file.getName());
                }
            }
            catch (IOException e) {
                LOG.warning(e);
            }
        }
        return false;
    }

    public static boolean pathContainsSymlink(File file) throws IOException {
        return !SystemUtils.IS_WINDOWS && !file.getCanonicalPath().equals(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPermissions(File file) {
        int result = -1;
        if (SystemUtils.IS_WINDOWS) {
            return -1;
        }
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec(new String[]{"stat", "-c", "%a", file.getAbsolutePath()});
            }
            catch (IOException e) {
                int n = 0;
                if (process != null) {
                    process.destroy();
                }
                return n;
            }
            InputStreamReader stdoutReader = new InputStreamReader(process.getInputStream());
            StringWriter stdoutWriter = new StringWriter();
            IOUtils.joinReaderToWriter(stdoutReader, stdoutWriter);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                result = Integer.parseInt(stdoutWriter.getBuffer().toString().trim(), 8);
            } else {
                LOG.warning("Unable to get permissions for '%s': stat exited with code %d", file.getAbsolutePath(), exitCode);
            }
        }
        catch (Exception e) {
            LOG.warning("Unable to get permissions for '" + file.getAbsolutePath() + "': " + e.getMessage(), e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return result;
    }

    public static boolean setPermissions(File file, int permissions) {
        if (SystemUtils.IS_WINDOWS || permissions < 0) {
            return false;
        }
        return FileSystemUtils.runChmod(file, Integer.toString(permissions, 8));
    }

    public static boolean setExecutable(File file) {
        return FileSystemUtils.setExecutable(file, true);
    }

    public static boolean setExecutable(File file, boolean executable) {
        if (executable) {
            return FileSystemUtils.runChmod(file, "a+x");
        }
        return FileSystemUtils.runChmod(file, "a-x");
    }

    public static boolean setWritable(File file) {
        return FileSystemUtils.setWritable(file, true);
    }

    public static boolean setWritable(File file, boolean writable) {
        if (writable) {
            if (SystemUtils.IS_WINDOWS) {
                try {
                    SystemUtils.runCommand("attrib", "-R", file.getAbsolutePath());
                    return true;
                }
                catch (IOException e) {
                    LOG.warning(e);
                    return false;
                }
            }
            return FileSystemUtils.runChmod(file, "a+w");
        }
        return file.setReadOnly();
    }

    private static boolean runChmod(File file, String arg) {
        if (!SystemUtils.IS_WINDOWS) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", arg, file.getAbsolutePath()});
                int exitCode = p.waitFor();
                return exitCode == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(File zipFile, File base, File source) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Source file '" + source.getAbsolutePath() + "' does not exist");
        }
        if (!FileSystemUtils.isParentOf(base, source)) {
            throw new IOException("Base '" + base.getAbsolutePath() + "' is not a parent of source '" + source.getAbsolutePath() + "'");
        }
        if (!zipFile.exists()) {
            if (!zipFile.getParentFile().isDirectory() && !zipFile.getParentFile().mkdirs()) {
                throw new IOException(String.format("Failed to create the directory '%s'", zipFile.getParentFile().getAbsolutePath()));
            }
            if (!zipFile.createNewFile()) {
                throw new IOException(String.format("Failed to create the zip file '%s'", zipFile.getAbsolutePath()));
            }
        }
        ZipOutputStream os = null;
        try {
            os = new ZipOutputStream(new FileOutputStream(zipFile));
            String sourcePath = source.getAbsolutePath().substring(base.getAbsolutePath().length());
            sourcePath = sourcePath.replace('\\', '/');
            sourcePath = sourcePath.replace(File.separatorChar, '/');
            if (sourcePath.startsWith("/")) {
                sourcePath = sourcePath.substring(1);
            }
            FileSystemUtils.addToZip(os, base, sourcePath);
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addToZip(ZipOutputStream os, File base, String sourcePath) throws IOException {
        File source = new File(base, sourcePath);
        if (!FileSystemUtils.isParentOf(base, source)) return;
        if (FileSystemUtils.isSymlink(source)) {
            return;
        }
        long modifiedTime = source.lastModified();
        if (source.isDirectory()) {
            String[] files;
            String dirPath = "";
            if (!"".equals(sourcePath)) {
                dirPath = sourcePath + '/';
                ZipEntry entry = new ZipEntry(dirPath);
                entry.setTime(modifiedTime);
                os.putNextEntry(entry);
            }
            String[] arr$ = files = source.list();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String filename = arr$[i$];
                String path = dirPath + filename;
                FileSystemUtils.addToZip(os, base, path);
                ++i$;
            }
            return;
        }
        ZipEntry entry = new ZipEntry(sourcePath);
        entry.setTime(modifiedTime);
        os.putNextEntry(entry);
        FileInputStream is = null;
        try {
            is = new FileInputStream(source);
            IOUtils.joinStreams(is, os);
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
    }

    public static byte[] getZipModeBlock(int mode) {
        byte[] data = new byte[18];
        FileSystemUtils.encodeZipShort(30062, data, 0);
        FileSystemUtils.encodeZipShort(14, data, 2);
        FileSystemUtils.encodeZipShort(mode, data, 8);
        Arrays.fill(data, 10, 18, (byte)0);
        CRC32 crc = new CRC32();
        crc.update(data, 8, 10);
        long checksum = crc.getValue();
        FileSystemUtils.encodeZipLong(checksum, data, 4);
        return data;
    }

    public static void encodeZipShort(int value, byte[] block, int offset) {
        block[offset] = (byte)(value & 0xFF);
        block[offset + 1] = (byte)((value & 0xFF00) >> 8);
    }

    public static int decodeZipShort(byte[] block, int offset) {
        int value = block[offset + 1] << 8 & 0xFF00;
        return value += block[offset] & 0xFF;
    }

    public static void encodeZipLong(long value, byte[] block, int offset) {
        block[offset] = (byte)(value & 0xFFL);
        block[offset + 1] = (byte)((value & 0xFF00L) >> 8);
        block[offset + 2] = (byte)((value & 0xFF0000L) >> 16);
        block[offset + 3] = (byte)((value & 0xFF000000L) >> 24);
    }

    public static long decodeZipLong(byte[] block, int offset) {
        long value = (long)(block[offset + 3] << 24) & 0xFF000000L;
        value += (long)(block[offset + 2] << 16 & 0xFF0000);
        value += (long)(block[offset + 1] << 8 & 0xFF00);
        return value += (long)(block[offset] & 0xFF);
    }

    public static int getModeFromZipBlock(byte[] block) {
        if (block.length == 18) {
            return FileSystemUtils.decodeZipShort(block, 8);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File zipFile, File dir) throws IOException {
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(new FileInputStream(zipFile));
            FileSystemUtils.extractZip(zin, dir);
        }
        catch (Throwable throwable) {
            IOUtils.close(zin);
            throw throwable;
        }
        IOUtils.close(zin);
    }

    public static void extractZip(ZipInputStream zin, File dir) throws IOException {
        ZipEntry entry;
        while ((entry = zin.getNextEntry()) != null) {
            File file = new File(dir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                if (!file.getParentFile().isDirectory()) {
                    file.getParentFile().mkdirs();
                }
                FileSystemUtils.unzip(zin, file);
            }
            file.setLastModified(entry.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream zin, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(file);
            byte[] b = new byte[512];
            while ((len = zin.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    public static boolean rename(File src, File dest, boolean force) {
        if (force && dest.exists()) {
            if (dest.isDirectory()) {
                FileSystemUtils.rmdir(dest);
            } else {
                dest.delete();
            }
        }
        return src.renameTo(dest);
    }

    public static boolean rename(File src, File dest) {
        return FileSystemUtils.rename(src, dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File file, String data) throws IOException {
        FileOutputStream os = null;
        OutputStreamWriter ow = null;
        try {
            os = new FileOutputStream(file);
            ow = new OutputStreamWriter(os);
            ow.write(data);
            ow.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(ow);
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(ow);
        IOUtils.close(os);
    }

    public static File createTempFile(String prefix, String suffix, String data) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        FileSystemUtils.createFile(file, data);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File file, byte[] data) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            os.write(data);
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(os);
    }

    public static File createTempFile(String prefix, String suffix, byte[] data) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        FileSystemUtils.createFile(file, data);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File file, InputStream is) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            IOUtils.joinStreams(is, os);
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(os);
    }

    public static boolean createSymlink(File symlink, File destination) throws IOException {
        if (LN_AVAILABLE) {
            SystemUtils.runCommand("ln", "-s", destination.getAbsolutePath(), symlink.getAbsolutePath());
            return true;
        }
        return false;
    }

    public static File composeFile(String ... parts) {
        String result = FileSystemUtils.composeFilename(parts);
        return new File(result);
    }

    public static String composeFilename(String ... parts) {
        return StringUtils.join(File.separator, parts);
    }

    public static String composeSearchPath(String ... parts) {
        return StringUtils.join(File.pathSeparator, parts);
    }

    public static String normaliseSeparators(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String denormaliseSeparators(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public static String localiseSeparators(String path) {
        if (File.separatorChar == '/') {
            return path.replace('\\', '/');
        }
        return path.replace('/', '\\');
    }

    public static boolean isRoot(File f) {
        return f.getParentFile() == null;
    }

    public static boolean isDirectory(String path) {
        if (TextUtils.stringSet((String)path)) {
            File f = new File(path);
            return f.isDirectory();
        }
        return false;
    }

    public static boolean isFile(String path) {
        if (TextUtils.stringSet((String)path)) {
            File f = new File(path);
            return f.isFile();
        }
        return false;
    }

    public static String getMimeType(File file) {
        String type = URLConnection.guessContentTypeFromName(file.getName());
        if (type == null) {
            try {
                type = URLConnection.guessContentTypeFromStream(new FileInputStream(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (type == null) {
                type = "text/plain";
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean filesMatch(File f1, File f2) throws IOException {
        boolean bl;
        byte[] b2;
        byte[] b1;
        if (f1.length() != f2.length()) {
            return false;
        }
        FileInputStream in1 = null;
        FileInputStream in2 = null;
        try {
            int n;
            in1 = new FileInputStream(f1);
            in2 = new FileInputStream(f2);
            b1 = new byte[1024];
            b2 = new byte[1024];
            while ((n = in2.read(b2)) > 0) {
                if (in1.read(b1) == n) break block6;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(in1);
            IOUtils.close(in2);
            throw throwable;
        }
        {
            block6: {
                IOUtils.close(in1);
                IOUtils.close(in2);
                return bl;
            }
            if (Arrays.equals(b2, b1)) continue;
            boolean bl2 = false;
            IOUtils.close(in1);
            IOUtils.close(in2);
            return bl2;
        }
        boolean bl3 = true;
        IOUtils.close(in1);
        IOUtils.close(in2);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translateEOLs(File file, byte[] eol, boolean preservePermissions) throws IOException {
        File tempFile = null;
        int permissions = -1;
        if (preservePermissions) {
            permissions = FileSystemUtils.getPermissions(file);
        }
        try {
            tempFile = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
            FileInputStream in = null;
            BufferedOutputStream out = null;
            try {
                int n;
                in = new FileInputStream(file);
                out = new BufferedOutputStream(new FileOutputStream(tempFile));
                byte[] buffer = new byte[1024];
                boolean skipNewline = false;
                while ((n = ((InputStream)in).read(buffer)) > 0) {
                    block10: for (int i = 0; i < n; ++i) {
                        byte b = buffer[i];
                        switch (b) {
                            case 13: {
                                ((OutputStream)out).write(eol);
                                skipNewline = true;
                                continue block10;
                            }
                            case 10: {
                                if (skipNewline) {
                                    skipNewline = false;
                                    continue block10;
                                }
                                ((OutputStream)out).write(eol);
                                continue block10;
                            }
                            default: {
                                skipNewline = false;
                                ((OutputStream)out).write(b);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                IOUtils.close(out);
                throw throwable;
            }
            IOUtils.close(in);
            IOUtils.close(out);
            file.delete();
            if (!tempFile.renameTo(file)) {
                throw new IOException("Unable to rename temporary file '" + tempFile.getAbsolutePath() + "' to '" + file.getAbsolutePath() + "'");
            }
            if (permissions >= 0) {
                FileSystemUtils.setPermissions(file, permissions);
            }
            tempFile = null;
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public static void copy(File dest, File ... src) throws IOException {
        if (src.length == 0) {
            return;
        }
        if (USE_UNIX_COPY) {
            FileSystemUtils.unixCopy(dest, src);
        } else {
            FileSystemUtils.javaCopy(dest, src);
        }
    }

    public static void delete(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!FileSystemUtils.rmdir(f)) {
                    throw new IOException("Cannot remove existing directory '" + f.getAbsolutePath() + "'");
                }
            } else if (!f.delete()) {
                throw new IOException("Cannot remove existing file '" + f.getAbsolutePath() + "'");
            }
        }
    }

    public static void ensureEmptyDirectory(File dir) throws IOException {
        FileSystemUtils.delete(dir);
        if (!dir.mkdirs()) {
            throw new IOException("Unable to create destination directory '" + dir.getAbsolutePath() + "'");
        }
    }

    private static void ensureNoDirectories(File[] files) throws IOException {
        for (File f : files) {
            if (!f.isDirectory()) continue;
            throw new IOException("Copy failed: multiple sources including an existing directory '" + f.getAbsolutePath() + "'");
        }
    }

    static void unixCopy(File dest, File ... src) throws IOException {
        String flags = "-p";
        if (src.length == 1) {
            if (src[0].isDirectory()) {
                FileSystemUtils.delete(dest);
                flags = flags + "r";
            }
        } else {
            FileSystemUtils.ensureNoDirectories(src);
            FileSystemUtils.ensureEmptyDirectory(dest);
        }
        LinkedList<String> argsList = new LinkedList<String>();
        argsList.add("cp");
        argsList.add(flags);
        for (File f : src) {
            argsList.add(f.getAbsolutePath());
        }
        argsList.add(dest.getAbsolutePath());
        String[] args = argsList.toArray(new String[argsList.size()]);
        Process child = Runtime.getRuntime().exec(args);
        try {
            int exit = child.waitFor();
            if (exit != 0) {
                LOG.warning("Copy using '" + StringUtils.join(" ", args) + "' failed, trying internal copy");
                FileSystemUtils.rmdir(dest);
                FileSystemUtils.javaCopy(dest, src);
            }
        }
        catch (InterruptedException e) {
            IOException ioe = new IOException("Interrupted while executing '" + StringUtils.join(" ", args) + "'");
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void javaCopy(File dest, File ... src) throws IOException {
        if (src.length == 1) {
            File singleSource = src[0];
            if (singleSource.isFile()) {
                if (dest.isDirectory() && (dest = new File(dest, singleSource.getName())).isDirectory()) {
                    throw new IOException("Copy failed: destination directory contains existing directory '" + dest.getAbsolutePath() + "' with same name as source file");
                }
                FileSystemUtils.delete(dest);
                IOUtils.copyFile(singleSource, dest);
                return;
            } else {
                if (!singleSource.isDirectory()) throw new IOException("Copy failed: source '" + singleSource.getAbsolutePath() + "' does not exist");
                FileSystemUtils.ensureEmptyDirectory(dest);
                FileSystemUtils.internalCopy(singleSource, dest);
            }
            return;
        } else {
            FileSystemUtils.ensureNoDirectories(src);
            FileSystemUtils.ensureEmptyDirectory(dest);
            for (File f : src) {
                FileSystemUtils.internalCopy(f, new File(dest, f.getName()));
            }
        }
    }

    protected static void internalCopy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.isDirectory() && !dest.mkdirs()) {
                throw new IOException(String.format("Copy failed. Failed to create dir %s", dest.getAbsolutePath()));
            }
            for (String file : src.list()) {
                FileSystemUtils.internalCopy(new File(src, file), new File(dest, file));
            }
        } else {
            if (dest.isFile()) {
                throw new IOException(String.format("Copy failed. Failed to copy to file %s, it already exists.", dest.getAbsolutePath()));
            }
            if (!dest.createNewFile()) {
                throw new IOException(String.format("Copy failed. Failed to create file %s", dest.getAbsolutePath()));
            }
            IOUtils.copyFile(src, dest);
        }
    }
}

