/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.svn;

import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.core.model.NumericalRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.personal.PersonalBuildSupport;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMUtils;
import com.zutubi.pulse.scm.WorkingCopy;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import com.zutubi.pulse.scm.svn.SVNSSHAuthenticationProvider;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWorkingCopy
extends PersonalBuildSupport
implements WorkingCopy {
    private File base;
    private SVNClientManager clientManager;
    private ConfigSupport configSupport;
    private ISVNAuthenticationManager authenticationManager;

    public SvnWorkingCopy(File path, Config config) {
        this.base = path;
        ISVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.clientManager = SVNClientManager.newInstance((ISVNOptions)options);
        this.configSupport = new ConfigSupport(config);
    }

    private void initAuthenticationManager() {
        if (this.authenticationManager == null) {
            String user = this.configSupport.getProperty("svn.username");
            if (user == null) {
                try {
                    SVNInfo info = this.clientManager.getWCClient().doInfo(this.base, null);
                    user = info.getURL().getUserInfo();
                }
                catch (SVNException e) {
                    // empty catch block
                }
            }
            if (user == null) {
                this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager();
            } else {
                this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)user, (String)this.getPassword(this.configSupport));
                if (this.configSupport.hasProperty("svn.keyfile")) {
                    String privateKeyFile = this.configSupport.getProperty("svn.keyfile");
                    String passphrase = this.configSupport.getProperty("svn.passphrase");
                    this.authenticationManager.setAuthenticationProvider((ISVNAuthenticationProvider)new SVNSSHAuthenticationProvider(user, privateKeyFile, passphrase));
                }
            }
            this.clientManager = SVNClientManager.newInstance((ISVNOptions)this.clientManager.getOptions(), (ISVNAuthenticationManager)this.authenticationManager);
        }
    }

    public String getPassword(ConfigSupport configSupport) {
        String password = configSupport.getProperty("svn.password");
        if (password == null && (password = this.passwordPrompt("Subversion password")) == null) {
            password = "";
        }
        return password;
    }

    @Override
    public boolean matchesRepository(Properties repositoryDetails) throws SCMException {
        SVNURL serverURL;
        String url = repositoryDetails.getProperty("svn.url");
        if (url == null) {
            throw new SCMException("Subversion repository details not returned by Pulse server");
        }
        try {
            serverURL = SVNURL.parseURIEncoded((String)url);
        }
        catch (SVNException e) {
            return true;
        }
        try {
            boolean eq;
            SVNInfo info = this.clientManager.getWCClient().doInfo(this.base, null);
            SVNURL wcUrl = info.getURL();
            boolean bl = eq = serverURL.getProtocol().equals(wcUrl.getProtocol()) && serverURL.hasPort() == wcUrl.hasPort() && serverURL.getPort() == wcUrl.getPort() && serverURL.getHost().equals(wcUrl.getHost()) && serverURL.getPath().equals(wcUrl.getPath());
            if (eq) {
                return true;
            }
            this.warning("Working copy's repository URL '" + wcUrl + "' does not match Pulse project's repository URL '" + url + "'");
            return false;
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    public WorkingCopyStatus getStatus() throws SCMException {
        return this.getStatus(true, this.base);
    }

    @Override
    public WorkingCopyStatus getLocalStatus(String ... spec) throws SCMException {
        File[] files = SCMUtils.specToFiles(this.base, spec);
        if (files == null) {
            return this.getStatus(false, this.base);
        }
        return this.getStatus(false, files);
    }

    private WorkingCopyStatus getStatus(boolean remote, File ... files) throws SCMException {
        if (remote) {
            this.initAuthenticationManager();
        }
        StatusHandler handler = new StatusHandler(this.base);
        try {
            SVNStatusClient statusClient = this.clientManager.getStatusClient();
            statusClient.setEventHandler((ISVNEventHandler)handler);
            for (File f : files) {
                statusClient.doStatus(f, true, remote, true, false, false, (ISVNStatusHandler)handler);
            }
            WorkingCopyStatus wcs = handler.getStatus();
            this.getProperties(wcs, handler.propertyChangedPaths);
            return wcs;
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    private void getProperties(WorkingCopyStatus wcs, List<String> propertyChangedPaths) throws SVNException {
        SVNWCClient wcc = this.clientManager.getWCClient();
        for (FileStatus fs : wcs) {
            SVNPropertyData property;
            if (fs.getState().requiresFile() && (property = wcc.doGetProperty(new File(this.base, fs.getPath()), "svn:eol-style", SVNRevision.WORKING, SVNRevision.WORKING, false)) != null) {
                fs.setProperty("eol", this.convertEOLStyle(property.getValue()));
            }
            if (fs.getState() != FileStatus.State.ADDED || (property = wcc.doGetProperty(new File(this.base, fs.getPath()), "svn:executable", SVNRevision.WORKING, SVNRevision.WORKING, false)) == null) continue;
            fs.setProperty("executable", "true");
        }
        for (String path : propertyChangedPaths) {
            FileStatus fs = wcs.getFileStatus(path);
            SVNPropertyData baseProperty = wcc.doGetProperty(new File(this.base, path), "svn:executable", SVNRevision.BASE, SVNRevision.BASE, false);
            SVNPropertyData workingProperty = wcc.doGetProperty(new File(this.base, path), "svn:executable", SVNRevision.WORKING, SVNRevision.WORKING, false);
            if (baseProperty == null) {
                if (workingProperty == null) continue;
                fs.setProperty("executable", "true");
                continue;
            }
            if (workingProperty != null) continue;
            fs.setProperty("executable", "false");
        }
    }

    private String convertEOLStyle(String eol) {
        if (eol.equals("native")) {
            return FileStatus.EOLStyle.NATIVE.toString();
        }
        if (eol.equals("CR")) {
            return FileStatus.EOLStyle.CARRIAGE_RETURN.toString();
        }
        if (eol.equals("CRLF")) {
            return FileStatus.EOLStyle.CARRIAGE_RETURN_LINEFEED.toString();
        }
        if (eol.equals("LF")) {
            return FileStatus.EOLStyle.LINEFEED.toString();
        }
        return FileStatus.EOLStyle.BINARY.toString();
    }

    @Override
    public Revision update() throws SCMException {
        this.initAuthenticationManager();
        SVNUpdateClient updateClient = this.clientManager.getUpdateClient();
        updateClient.setEventHandler((ISVNEventHandler)new UpdateHandler());
        try {
            long rev = updateClient.doUpdate(this.base, SVNRevision.HEAD, true);
            return new NumericalRevision(rev);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    private SCMException convertException(SVNException e) {
        return new SCMException(e.getMessage(), e);
    }

    private FileStatus convertStatus(SVNStatus svnStatus, List<String> propertyChangedPaths) {
        boolean directory;
        SVNStatusType contentsStatus = svnStatus.getContentsStatus();
        String path = svnStatus.getFile().getPath();
        boolean bl = directory = svnStatus.getKind() == SVNNodeKind.DIR;
        if (path.startsWith(this.base.getPath())) {
            path = path.substring(this.base.getPath().length());
        }
        if (path.startsWith("/") || path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        FileStatus.State fileState = contentsStatus == SVNStatusType.STATUS_NORMAL ? (svnStatus.isCopied() ? FileStatus.State.ADDED : FileStatus.State.UNCHANGED) : (contentsStatus == SVNStatusType.STATUS_ADDED ? FileStatus.State.ADDED : (contentsStatus == SVNStatusType.STATUS_CONFLICTED ? FileStatus.State.UNRESOLVED : (contentsStatus == SVNStatusType.STATUS_DELETED ? FileStatus.State.DELETED : (contentsStatus == SVNStatusType.STATUS_EXTERNAL ? FileStatus.State.UNSUPPORTED : (contentsStatus == SVNStatusType.STATUS_INCOMPLETE ? FileStatus.State.INCOMPLETE : (contentsStatus == SVNStatusType.STATUS_MERGED ? FileStatus.State.MERGED : (contentsStatus == SVNStatusType.STATUS_MISSING ? FileStatus.State.MISSING : (contentsStatus == SVNStatusType.STATUS_MODIFIED ? FileStatus.State.MODIFIED : (contentsStatus == SVNStatusType.STATUS_OBSTRUCTED ? FileStatus.State.OBSTRUCTED : (contentsStatus == SVNStatusType.STATUS_REPLACED ? FileStatus.State.REPLACED : FileStatus.State.UNCHANGED))))))))));
        SVNStatusType propertiesStatus = svnStatus.getPropertiesStatus();
        if (propertiesStatus != SVNStatusType.STATUS_NONE) {
            propertyChangedPaths.add(path);
        }
        return new FileStatus(path, fileState, directory);
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
    }

    private class UpdateHandler
    implements ISVNEventHandler {
        private UpdateHandler() {
        }

        public void handleEvent(SVNEvent event, double progress) {
            String message;
            SVNEventAction action = event.getAction();
            String pathChangeType = " ";
            if (action == SVNEventAction.UPDATE_ADD) {
                pathChangeType = "A";
            } else if (action == SVNEventAction.UPDATE_DELETE) {
                pathChangeType = "D";
            } else if (action == SVNEventAction.UPDATE_UPDATE) {
                SVNStatusType contentsStatus = event.getContentsStatus();
                if (contentsStatus == SVNStatusType.CHANGED) {
                    pathChangeType = "U";
                } else if (contentsStatus == SVNStatusType.CONFLICTED) {
                    pathChangeType = "C";
                } else if (contentsStatus == SVNStatusType.MERGED) {
                    pathChangeType = "G";
                }
            } else {
                if (action == SVNEventAction.UPDATE_EXTERNAL) {
                    SvnWorkingCopy.this.status("Fetching external item into '" + event.getFile().getAbsolutePath() + "'");
                    SvnWorkingCopy.this.status("External at revision " + event.getRevision());
                    return;
                }
                if (action == SVNEventAction.UPDATE_COMPLETED) {
                    SvnWorkingCopy.this.status("Updated to revision " + event.getRevision());
                    return;
                }
                if (action == SVNEventAction.ADD) {
                    SvnWorkingCopy.this.status("A     " + event.getPath());
                    return;
                }
                if (action == SVNEventAction.DELETE) {
                    SvnWorkingCopy.this.status("D     " + event.getPath());
                    return;
                }
                if (action == SVNEventAction.LOCKED) {
                    SvnWorkingCopy.this.status("L     " + event.getPath());
                    return;
                }
                if (action == SVNEventAction.LOCK_FAILED) {
                    SvnWorkingCopy.this.status("Failed to lock: " + event.getPath());
                    return;
                }
            }
            SVNStatusType propertiesStatus = event.getPropertiesStatus();
            String propertiesChangeType = " ";
            if (propertiesStatus == SVNStatusType.CHANGED) {
                propertiesChangeType = "U";
            } else if (propertiesStatus == SVNStatusType.CONFLICTED) {
                propertiesChangeType = "C";
            } else if (propertiesStatus == SVNStatusType.MERGED) {
                propertiesChangeType = "G";
            }
            String lockLabel = " ";
            SVNStatusType lockType = event.getLockStatus();
            if (lockType == SVNStatusType.LOCK_UNLOCKED) {
                lockLabel = "B";
            }
            if ((message = pathChangeType + propertiesChangeType + lockLabel + "       " + event.getPath()).trim().length() > 0) {
                SvnWorkingCopy.this.status(message);
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }
    }

    private class StatusHandler
    implements ISVNEventHandler,
    ISVNStatusHandler {
        WorkingCopyStatus status;
        List<String> propertyChangedPaths = new LinkedList<String>();

        public StatusHandler(File base) {
            this.status = new WorkingCopyStatus(base);
        }

        public void handleEvent(SVNEvent event, double progress) {
            SVNEventAction action = event.getAction();
            if (action == SVNEventAction.STATUS_COMPLETED) {
                NumericalRevision rev = new NumericalRevision(event.getRevision());
                this.status.setRevision(rev);
                SvnWorkingCopy.this.status("Repository revision: " + rev.getRevisionString());
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public void handleStatus(SVNStatus svnStatus) {
            FileStatus fs = SvnWorkingCopy.this.convertStatus(svnStatus, this.propertyChangedPaths);
            if (svnStatus.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE || svnStatus.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE) {
                fs.setOutOfDate(true);
            }
            if (fs.isInteresting()) {
                SvnWorkingCopy.this.status(fs.toString());
                this.status.add(fs);
            }
        }

        public WorkingCopyStatus getStatus() {
            return this.status;
        }
    }
}

