/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.zutubi.pulse.core.model.NumericalRevision;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.p4.P4ErrorDetectingHandler;
import com.zutubi.pulse.scm.p4.P4Handler;
import com.zutubi.pulse.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4Client {
    private static final String ASCII_CHARSET = "US-ASCII";
    private Map<String, String> p4Env = new HashMap<String, String>();
    private ProcessBuilder p4Builder = new ProcessBuilder(new String[0]);
    private Pattern changesPattern = Pattern.compile("^Change ([0-9]+) on (.+) by (.+)@(.+) '(.+)'$", 8);
    private Pattern lineSplitterPattern = Pattern.compile("\r?\n");
    private static final String ROOT_PREFIX = "Root:";

    public Map<String, String> getEnv() {
        return this.p4Env;
    }

    public void setEnv(String variable, String value) {
        if (value != null) {
            this.p4Env.put(variable, value);
            this.p4Builder.environment().put(variable, value);
        }
    }

    public void setWorkingDir(File dir) {
        this.p4Builder.directory(dir);
    }

    public P4Result runP4(String input, String ... commands) throws SCMException {
        return this.runP4(true, input, commands);
    }

    public P4Result runP4(boolean throwOnStderr, String input, String ... commands) throws SCMException {
        final P4Result result = new P4Result();
        this.runP4WithHandler(new P4ErrorDetectingHandler(throwOnStderr){

            public void handleStdout(String line) {
                result.stdout.append(line);
                result.stdout.append('\n');
            }

            public void handleExitCode(int code) throws SCMException {
                super.handleExitCode(code);
                result.stderr = this.getStderr();
                result.exitCode = code;
            }

            public void checkCancelled() throws SCMCancelledException {
            }
        }, input, commands);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runP4WithHandler(P4Handler handler, String input, String ... commands) throws SCMException {
        Process child;
        this.p4Builder.command(commands);
        try {
            child = this.p4Builder.start();
        }
        catch (IOException e) {
            throw new SCMException("Could not start p4 process: " + e.getMessage(), e);
        }
        if (input != null) {
            try {
                OutputStream stdinStream = child.getOutputStream();
                stdinStream.write(input.getBytes(ASCII_CHARSET));
                stdinStream.close();
            }
            catch (IOException e) {
                throw new SCMException("Error writing to input of p4 process", e);
            }
        }
        BufferedReader stdoutReader = null;
        BufferedReader stderrReader = null;
        try {
            String line;
            stdoutReader = new BufferedReader(new InputStreamReader(child.getInputStream(), ASCII_CHARSET));
            stderrReader = new BufferedReader(new InputStreamReader(child.getErrorStream(), ASCII_CHARSET));
            while ((line = stdoutReader.readLine()) != null) {
                handler.handleStdout(line);
                handler.checkCancelled();
            }
            while ((line = stderrReader.readLine()) != null) {
                handler.handleStderr(line);
                handler.checkCancelled();
            }
            handler.handleExitCode(child.waitFor());
            IOUtils.close(stdoutReader);
        }
        catch (IOException e) {
            throw new SCMException("Error reading output of p4 process", e);
            catch (InterruptedException e2) {
                return;
            }
            catch (SCMCancelledException e3) {
                child.destroy();
                throw e3;
            }
        }
        finally {
            IOUtils.close(stdoutReader);
            IOUtils.close(stderrReader);
        }
        IOUtils.close(stderrReader);
        return;
    }

    public void createClient(String templateClient, String clientName, File toDirectory) throws SCMException {
        P4Result result = this.runP4(null, "p4", "-c", templateClient, "client", "-o");
        String clientSpec = result.stdout.toString();
        clientSpec = clientSpec.replaceAll("\nRoot:.*", Matcher.quoteReplacement("\nRoot: " + toDirectory.getAbsolutePath()));
        clientSpec = clientSpec.replaceAll("\nHost:.*", Matcher.quoteReplacement("\nHost: "));
        clientSpec = clientSpec.replaceAll("\nClient:.*" + templateClient, Matcher.quoteReplacement("\nClient: " + clientName));
        clientSpec = clientSpec.replaceAll("//" + templateClient + "/", Matcher.quoteReplacement("//" + clientName + "/"));
        this.runP4(clientSpec, "p4", "client", "-i");
    }

    public File getClientRoot() throws SCMException {
        final File[] result = new File[1];
        this.runP4WithHandler(new P4ErrorDetectingHandler(true){

            public void handleStdout(String line) throws SCMException {
                if (line.startsWith(P4Client.ROOT_PREFIX)) {
                    result[0] = new File(line.substring(P4Client.ROOT_PREFIX.length()).trim());
                }
            }

            public void checkCancelled() throws SCMCancelledException {
            }
        }, null, "p4", "client", "-o");
        return result[0];
    }

    public Map<String, String> getServerInfo(String client) throws SCMException {
        TreeMap<String, String> info = new TreeMap<String, String>();
        P4Result result = client == null ? this.runP4(null, "p4", "info") : this.runP4(null, "p4", "-c", client, "info");
        for (String line : this.splitLines(result)) {
            int index = line.indexOf(58);
            if (index <= 0 || index >= line.length() - 1) continue;
            info.put(line.substring(0, index).trim(), line.substring(index + 1).trim());
        }
        return info;
    }

    public NumericalRevision getLatestRevisionForFiles(String clientName, String ... files) throws SCMException {
        ArrayList<String> args = new ArrayList<String>(8 + files.length);
        args.add("p4");
        if (clientName != null) {
            args.add("-c");
            args.add(clientName);
        }
        args.add("changes");
        args.add("-s");
        args.add("submitted");
        args.add("-m");
        args.add("1");
        for (String file : files) {
            args.add(file);
        }
        P4Result result = this.runP4(null, args.toArray(new String[args.size()]));
        Matcher matcher = this.changesPattern.matcher(result.stdout);
        if (matcher.find()) {
            return new NumericalRevision(Long.parseLong(matcher.group(1)));
        }
        return new NumericalRevision(0L);
    }

    public long createChangelist(String description) throws SCMException {
        String response;
        P4Result result = this.runP4(null, "p4", "change", "-o");
        String changeSpec = result.stdout.toString();
        changeSpec = changeSpec.replaceAll("<enter description here>", Matcher.quoteReplacement(description));
        result = this.runP4(changeSpec, "p4", "change", "-i");
        Pattern created = Pattern.compile("Change ([0-9]+) created.");
        Matcher m = created.matcher(response = result.stdout.toString().trim());
        if (m.matches()) {
            return Long.parseLong(m.group(1));
        }
        throw new SCMException("Unrecognised response from p4 change '" + response + "'");
    }

    public void submit(String comment) throws SCMException {
        P4Result result = this.runP4(null, "p4", "change", "-o");
        String out = result.stdout.toString();
        out = out.replace("<enter description here>", comment);
        this.runP4(out, "p4", "submit", "-i");
    }

    public String[] splitLines(P4Result result) {
        return this.lineSplitterPattern.split(result.stdout);
    }

    public Pattern getChangesPattern() {
        return this.changesPattern;
    }

    public class P4Result {
        public StringBuffer stdout = new StringBuffer();
        public StringBuffer stderr = new StringBuffer();
        public int exitCode;
    }
}

