/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs.client.connection;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import com.zutubi.pulse.scm.cvs.client.connection.ExtConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class SshConnection
extends ExtConnection {
    public static final int DEFAULT_SSH_PORT = 22;
    private SshClient sshClient;
    private SessionChannelClient channelClient;

    public SshConnection(CVSRoot cvsRoot) {
        super(cvsRoot);
        if (this.getPort() == 0) {
            this.setPort(22);
        }
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        try {
            this.connect();
            this.authenticate();
            this.channelClient = this.sshClient.openSessionChannel();
            boolean okay = this.channelClient.executeCommand("cvs server");
            if (!okay) {
                throw new CommandAbortedException("Unable to execute cvs server process.", "");
            }
            this.setInputStream(new LoggedDataInputStream((InputStream)this.channelClient.getInputStream()));
            this.setOutputStream(new LoggedDataOutputStream((OutputStream)this.channelClient.getOutputStream()));
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws AuthenticationException {
        try {
            try {
                this.connect();
                this.authenticate();
            }
            finally {
                this.close();
            }
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e, "");
        }
    }

    private void authenticate() throws IOException, AuthenticationException {
        PasswordAuthenticationClient pwdAuth = new PasswordAuthenticationClient();
        pwdAuth.setUsername(this.user);
        pwdAuth.setPassword(this.password);
        int result = this.sshClient.authenticate((SshAuthenticationClient)pwdAuth);
        switch (result) {
            case 4: {
                break;
            }
            default: {
                throw new AuthenticationException("Authentication failed, authentication protocol state: " + result, "");
            }
        }
    }

    private void connect() throws IOException {
        SshConnectionProperties properties = new SshConnectionProperties();
        properties.setHost(this.host);
        properties.setPort(this.port);
        this.sshClient = new SshClient();
        this.sshClient.connect(properties, (HostKeyVerification)new IgnoreHostKeyVerification());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.channelClient != null) {
                this.channelClient.close();
            }
        }
        finally {
            if (this.sshClient != null && this.sshClient.isConnected()) {
                this.sshClient.disconnect();
            }
            this.sshClient = null;
            this.channelClient = null;
        }
    }

    public boolean isOpen() {
        return this.sshClient != null && this.sshClient.isAuthenticated();
    }

    public void modifyInputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyOutputStream(this.getOutputStream());
    }

    public int getPort() {
        return this.port;
    }
}

