/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs.client.commands;

import com.zutubi.pulse.core.model.Change;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HistoryInfo {
    protected String code;
    protected String pathInRepository;
    protected String user;
    protected String file;
    protected String revision;
    protected String date;
    protected String time;
    protected String timezone;
    protected String workingpath;
    static final SimpleDateFormat LOGDATE = new SimpleDateFormat("yyyy-MM-dd HH:mm Z");

    public boolean isCheckout() {
        return "O".equals(this.getCode());
    }

    public boolean isUpdate() {
        return "W".equals(this.getCode()) || "U".equals(this.getCode()) || "G".equals(this.getCode()) || "C".equals(this.getCode());
    }

    public boolean isCommit() {
        return this.isModified() || this.isAdded() || this.isRemoved();
    }

    public boolean isModified() {
        return "M".equals(this.getCode());
    }

    public boolean isAdded() {
        return "A".equals(this.getCode());
    }

    public boolean isRemoved() {
        return "R".equals(this.getCode());
    }

    public boolean isTag() {
        return "T".equals(this.getCode());
    }

    public boolean isExport() {
        return "E".equals(this.getCode());
    }

    public boolean isRelease() {
        return "F".equals(this.getCode());
    }

    public String getUser() {
        return this.user;
    }

    public String getFile() {
        return this.file;
    }

    public String getPathInRepository() {
        return this.pathInRepository;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getCode() {
        return this.code;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getWorkingpath() {
        return this.workingpath;
    }

    public Date getInfoDate() {
        try {
            if (this.getDate() != null) {
                return LOGDATE.parse(this.getDate() + " " + this.getTime() + " " + this.getTimezone());
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Change.Action getAction() {
        if (this.isCommit()) {
            if (this.isAdded()) {
                return Change.Action.ADD;
            }
            if (this.isRemoved()) {
                return Change.Action.DELETE;
            }
            if (this.isModified()) {
                return Change.Action.EDIT;
            }
        }
        return Change.Action.UNKNOWN;
    }
}

