/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs.client.commands;

import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.cvs.client.commands.HistoryInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.Builder;

public class HistoryBuilder
implements Builder {
    private List infos = new LinkedList();
    static final String NO_RECORDS = "No records selected.";

    public void parseLine(String line, boolean isErrorMessage) {
        if (!isErrorMessage && !line.equals(NO_RECORDS)) {
            try {
                HistoryInfo info = this.parse(line);
                this.infos.add(info);
            }
            catch (SCMException e) {
                e.printStackTrace();
            }
        }
    }

    public void parseEnhancedMessage(String s, Object obj) {
    }

    public void outputDone() {
    }

    public List getHistoryInfo() {
        return Collections.unmodifiableList(this.infos);
    }

    private HistoryInfo parse(String data) throws SCMException {
        HistoryInfo info = new HistoryInfo();
        StringTokenizer tokenizer = new StringTokenizer(data, " ", false);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        if (tokens.size() < 8) {
            throw new SCMException("Unable to extract history info from data: " + data);
        }
        info.code = (String)tokens.get(0);
        info.date = (String)tokens.get(1);
        info.time = (String)tokens.get(2);
        info.timezone = (String)tokens.get(3);
        info.user = (String)tokens.get(4);
        if (info.isUpdate() || info.isCommit()) {
            info.revision = (String)tokens.get(5);
            info.file = (String)tokens.get(6);
            info.pathInRepository = (String)tokens.get(7);
            tokens.get(8);
            info.workingpath = (String)tokens.get(9);
        } else {
            info.file = (String)tokens.get(5);
            info.pathInRepository = ((String)tokens.get(6)).substring(1, ((String)tokens.get(6)).length() - 1);
            info.workingpath = (String)tokens.get(7);
        }
        return info;
    }
}

