/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs.client;

import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.CvsFileRevision;
import com.zutubi.pulse.core.model.CvsRevision;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogInformationAnalyser {
    private String uid;
    private CVSRoot root;

    public LogInformationAnalyser(String uid, CVSRoot root) {
        this.uid = uid;
        this.root = root;
    }

    public Date latestUpdate(List<LogInformation> rlogResponse) {
        List<Revision> revisions = this.extractRevisions(rlogResponse, null);
        if (revisions.size() == 0) {
            return null;
        }
        Collections.sort(revisions, new RevisionDateComparator());
        Revision latestChange = revisions.get(revisions.size() - 1);
        return latestChange.getDate();
    }

    private List<Revision> extractRevisions(List<LogInformation> logInformation, String tag) {
        LinkedList<Revision> revisions = new LinkedList<Revision>();
        for (LogInformation logInfo : logInformation) {
            for (Object obj : logInfo.getRevisionList()) {
                LogInformation.Revision rev = (LogInformation.Revision)obj;
                if ("dead".equals(rev.getState()) && rev.getNumber().endsWith(".1")) continue;
                Revision revision = new Revision(rev, this.root);
                revision.setTag(tag);
                revisions.add(revision);
            }
        }
        return revisions;
    }

    public List<Changelist> extractChangelists(List<LogInformation> rlogResponse, String tag) {
        List<Revision> simpleChanges = this.extractRevisions(rlogResponse, tag);
        Collections.sort(simpleChanges, new Comparator<Revision>(){

            @Override
            public int compare(Revision changeA, Revision changeB) {
                int comparison = changeA.getAuthor().compareTo(changeB.getAuthor());
                if (comparison != 0) {
                    return comparison;
                }
                comparison = changeA.getTag().compareTo(changeB.getTag());
                if (comparison != 0) {
                    return comparison;
                }
                return changeA.getDate().compareTo(changeB.getDate());
            }
        });
        LinkedList<LocalChangeSet> changeSets = new LinkedList<LocalChangeSet>();
        LocalChangeSet changeSet = null;
        for (Revision change : simpleChanges) {
            if (changeSet == null) {
                changeSet = new LocalChangeSet(change);
                continue;
            }
            if (changeSet.belongsTo(change)) {
                changeSet.add(change);
                continue;
            }
            changeSets.add(changeSet);
            changeSet = new LocalChangeSet(change);
        }
        if (changeSet != null) {
            changeSets.add(changeSet);
        }
        LinkedList<LocalChangeSet> refinedSets = new LinkedList<LocalChangeSet>();
        for (LocalChangeSet set : changeSets) {
            refinedSets.addAll(set.refine());
        }
        LinkedList<Changelist> changelists = new LinkedList<Changelist>();
        for (LocalChangeSet set : refinedSets) {
            List<Revision> localChanges = set.getChanges();
            Revision lastChange = localChanges.get(localChanges.size() - 1);
            CvsRevision rev = new CvsRevision(lastChange.getAuthor(), lastChange.getTag(), lastChange.getMessage(), lastChange.getDate());
            Changelist changelist = new Changelist(this.uid, rev);
            for (Revision change : localChanges) {
                changelist.addChange(new Change(change.getFilename(), new CvsFileRevision(change.getRevision()), change.getAction()));
            }
            changelists.add(changelist);
        }
        return changelists;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RevisionDateComparator
    implements Comparator<Revision> {
        private RevisionDateComparator() {
        }

        @Override
        public int compare(Revision o1, Revision o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    }

    public class Revision {
        private LogInformation.Revision log;
        private String tag;
        private CVSRoot root;

        public Revision(LogInformation.Revision log, CVSRoot root) {
            if (log == null) {
                throw new IllegalArgumentException("Log Information cannot be null.");
            }
            this.log = log;
            this.root = root;
        }

        public String getAuthor() {
            return this.log.getAuthor();
        }

        public String getRevision() {
            return this.log.getNumber();
        }

        public String getTag() {
            if (this.tag == null) {
                return "";
            }
            return this.tag;
        }

        public void setTag(String branch) {
            this.tag = branch;
        }

        public Date getDate() {
            return this.log.getDate();
        }

        public String getMessage() {
            return this.log.getMessage();
        }

        public String getFilename() {
            String filename = this.log.getLogInfoHeader().getRepositoryFilename();
            if (filename.endsWith(",v")) {
                filename = filename.substring(0, filename.length() - 2);
            }
            if (filename.startsWith(this.root.getRepository())) {
                filename = filename.substring(this.root.getRepository().length());
            }
            return filename;
        }

        public Change.Action getAction() {
            if (this.log.getAddedLines() == 0 && this.log.getRemovedLines() == 0) {
                if (!this.log.getState().equalsIgnoreCase("dead")) {
                    return Change.Action.ADD;
                }
                return Change.Action.DELETE;
            }
            return Change.Action.EDIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalChangeSet {
        private final List<Revision> changes = new LinkedList<Revision>();

        LocalChangeSet(Revision c) {
            this.changes.add(c);
        }

        void add(Revision c) {
            this.changes.add(c);
        }

        boolean belongsTo(Revision otherChange) {
            if (this.changes.size() == 0) {
                return true;
            }
            Revision previousChange = this.changes.get(0);
            return previousChange.getAuthor().equals(otherChange.getAuthor()) && previousChange.getTag().equals(otherChange.getTag()) && previousChange.getMessage().equals(otherChange.getMessage());
        }

        public List<LocalChangeSet> refine() {
            HashMap<String, String> filenames = new HashMap<String, String>();
            LinkedList<LocalChangeSet> changesets = new LinkedList<LocalChangeSet>();
            LocalChangeSet changeSet = null;
            for (Revision change : this.changes) {
                if (filenames.containsKey(change.getFilename())) {
                    filenames.clear();
                    changesets.add(changeSet);
                    filenames.put(change.getFilename(), change.getFilename());
                    changeSet = new LocalChangeSet(change);
                    continue;
                }
                filenames.put(change.getFilename(), change.getFilename());
                if (changeSet == null) {
                    changeSet = new LocalChangeSet(change);
                    continue;
                }
                changeSet.add(change);
            }
            if (changeSet != null) {
                changesets.add(changeSet);
            }
            return changesets;
        }

        public List<Revision> getChanges() {
            return this.changes;
        }
    }
}

