/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs.client;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.model.CvsRevision;
import com.zutubi.pulse.scm.SCMCheckoutEventHandler;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.cvs.client.ConnectionFactory;
import com.zutubi.pulse.scm.cvs.client.LoggingOutputStream;
import com.zutubi.pulse.scm.cvs.client.commands.CheckoutListener;
import com.zutubi.pulse.scm.cvs.client.commands.LogListener;
import com.zutubi.pulse.scm.cvs.client.commands.StatusListener;
import com.zutubi.pulse.scm.cvs.client.commands.UpdateListener;
import com.zutubi.pulse.scm.cvs.client.commands.VersionCommand;
import com.zutubi.pulse.scm.cvs.client.util.CvsUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvsClient {
    public static final com.zutubi.pulse.util.logging.Logger LOG = com.zutubi.pulse.util.logging.Logger.getLogger(CvsClient.class);
    private static int COMMAND_COUNT = 0;
    private static final SimpleDateFormat SERVER_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private CVSRoot root;
    private String password;
    private static final String RLOG_SUPPRESS_HEADER = "cvs.rlog.suppressHeader";

    public void setRoot(CVSRoot root) {
        this.root = root;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String version() throws SCMException {
        VersionCommand version = new VersionCommand();
        if (!this.executeCommand((Command)version, null, null)) {
            throw new SCMException("failed to retrieve the cvs server version details.");
        }
        return version.getVersion();
    }

    public void update(File workingDirectory, CvsRevision revision, SCMCheckoutEventHandler handler) throws SCMException {
        UpdateListener listener = null;
        if (handler != null) {
            listener = new UpdateListener(handler);
        }
        this.update(workingDirectory, revision, (CVSListener)listener);
    }

    public void update(File workingDirectory, CvsRevision revision, CVSListener listener) throws SCMException {
        UpdateCommand update = new UpdateCommand();
        update.setPruneDirectories(true);
        update.setBuildDirectories(true);
        update.setResetStickyOnes(true);
        if (revision != null) {
            if (TextUtils.stringSet((String)revision.getBranch())) {
                update.setUpdateByRevision(revision.getBranch());
            }
            if (revision.getDate() != null) {
                update.setUpdateByDate(SERVER_DATE.format(revision.getDate()));
            }
        }
        if (!this.executeCommand((Command)update, workingDirectory, listener)) {
            throw new SCMException("Failed to update.");
        }
    }

    public void checkout(File workdir, String module, CvsRevision revision, SCMCheckoutEventHandler handler) throws SCMException {
        this.checkout(workdir, module, revision, true, handler);
    }

    public void checkout(File workdir, String module, CvsRevision revision, boolean recursive, SCMCheckoutEventHandler handler) throws SCMException {
        CheckoutCommand checkout = new CheckoutCommand();
        checkout.setModule(module);
        checkout.setRecursive(recursive);
        if (TextUtils.stringSet((String)revision.getBranch())) {
            checkout.setCheckoutByRevision(revision.getBranch());
        }
        if (revision.getDate() != null) {
            checkout.setCheckoutByDate(SERVER_DATE.format(revision.getDate()));
        }
        CheckoutListener listener = null;
        if (handler != null) {
            listener = new CheckoutListener(handler);
        }
        if (!this.executeCommand((Command)checkout, workdir, (CVSListener)listener)) {
            throw new SCMException("Failed to checkout.");
        }
    }

    public void tag(String module, CvsRevision revision, String name) throws SCMException {
        this.tag(module, revision, name, false);
    }

    public void tag(String module, CvsRevision revision, String name, boolean moveExisting) throws SCMException {
        RtagCommand tag = new RtagCommand();
        tag.setModules(new String[]{module});
        tag.setTag(name);
        tag.setOverrideExistingTag(moveExisting);
        tag.setRecursive(true);
        if (TextUtils.stringSet((String)revision.getBranch())) {
            tag.setTagByRevision(revision.getBranch());
        }
        if (revision.getDate() != null) {
            tag.setTagByDate(SERVER_DATE.format(revision.getDate()));
        }
        if (!this.executeCommand((Command)tag, null, null)) {
            throw new SCMException("Failed to tag.");
        }
    }

    public void deleteTag(String module, String name) throws SCMException {
        RtagCommand tag = new RtagCommand();
        tag.setModules(new String[]{module});
        tag.setTag(name);
        tag.setDeleteTag(true);
        tag.setRecursive(true);
        tag.setClearFromRemoved(true);
        if (!this.executeCommand((Command)tag, null, null)) {
            throw new SCMException("Failed to delete tag.");
        }
    }

    public List<LogInformation> rlog(String module, CvsRevision from, CvsRevision to) throws SCMException {
        return this.rlog(module, from, to, false);
    }

    public List<LogInformation> rlog(String module, CvsRevision from, CvsRevision to, boolean verbose) throws SCMException {
        LogListener listener;
        String branch;
        RlogCommand rlog = new RlogCommand();
        rlog.setModule(module);
        boolean useSuppressHeader = true;
        if (System.getProperties().containsKey(RLOG_SUPPRESS_HEADER)) {
            useSuppressHeader = Boolean.getBoolean(RLOG_SUPPRESS_HEADER);
        }
        if (useSuppressHeader && !verbose) {
            rlog.setSuppressHeader(true);
        }
        Object object = from == null ? (to == null ? null : to.getBranch()) : (branch = from.getBranch());
        if (TextUtils.stringSet((String)branch)) {
            rlog.setRevisionFilter(branch);
        } else {
            rlog.setDefaultBranch(true);
        }
        String dateFilter = "";
        String del = "<=";
        if (from != null && from.getDate() != null) {
            dateFilter = SERVER_DATE.format(from.getDate()) + del;
            del = "";
        }
        if (to != null && to.getDate() != null) {
            dateFilter = dateFilter + del + SERVER_DATE.format(to.getDate());
        }
        if (TextUtils.stringSet((String)dateFilter)) {
            rlog.setDateFilter(dateFilter);
        }
        if (!this.executeCommand((Command)rlog, null, (CVSListener)(listener = new LogListener()))) {
            throw new SCMException("Failed to retrieve the cvs server changes between revisions.");
        }
        return listener.getLogInfo();
    }

    public List<StatusInformation> status(File workingCopy) throws SCMException {
        StatusListener listener = new StatusListener();
        this.status(workingCopy, null, (CVSListener)listener);
        return listener.getInfo();
    }

    public void status(File workingCopy, File[] files, CVSListener listener) throws SCMException {
        StatusCommand status = new StatusCommand();
        status.setRecursive(true);
        if (files == null) {
            status.setFiles(new File[]{workingCopy});
        } else {
            status.setFiles(files);
        }
        if (!this.executeCommand((Command)status, workingCopy, listener)) {
            throw new SCMException("Failed to run status command.");
        }
    }

    public void testConnection() throws SCMException {
        Connection connection = null;
        try {
            connection = ConnectionFactory.getConnection(this.root, this.password);
            connection.verify();
        }
        catch (AuthenticationException e) {
            try {
                throw new SCMException(e);
            }
            catch (Throwable throwable) {
                CvsUtils.close(connection);
                throw throwable;
            }
        }
        CvsUtils.close(connection);
    }

    /*
     * Exception decompiling
     */
    public boolean executeCommand(Command command, File localPath, CVSListener listener) throws SCMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connection openConnection() throws AuthenticationException, CommandAbortedException {
        Connection connection = ConnectionFactory.getConnection(this.root, this.password);
        connection.open();
        return connection;
    }

    static {
        SERVER_DATE.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Field outLogStream = Logger.class.getDeclaredField("outLogStream");
            Field inLogStream = Logger.class.getDeclaredField("inLogStream");
            Field logging = Logger.class.getDeclaredField("logging");
            outLogStream.setAccessible(true);
            inLogStream.setAccessible(true);
            logging.setAccessible(true);
            outLogStream.set(Logger.class, new LoggingOutputStream(LOG, Level.FINER));
            inLogStream.set(Logger.class, new LoggingOutputStream(LOG, Level.FINEST));
            logging.set(Logger.class, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.warning(e);
        }
    }
}

