/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.resources;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.resources.ResourceConstructor;
import com.zutubi.pulse.util.SystemUtils;
import java.io.File;
import java.io.IOException;

public class StandardTemplateResourceConstructor
implements ResourceConstructor {
    private String resourceName;
    private String scriptName;

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public boolean isResourceHome(String home) {
        return home != null && this.isResourceHome(new File(home));
    }

    public boolean isResourceHome(File home) {
        if (home == null || !home.isDirectory()) {
            return false;
        }
        File bin = new File(home, "bin");
        if (SystemUtils.IS_WINDOWS) {
            return new File(bin, this.scriptName + ".bat").isFile();
        }
        return new File(bin, this.scriptName).isFile();
    }

    public Resource createResource(String home) throws IOException {
        return this.createResource(new File(home));
    }

    public Resource createResource(File home) throws IOException {
        try {
            Resource resource = new Resource(this.resourceName);
            ResourceVersion version = new ResourceVersion(home.getName());
            resource.add(version);
            resource.setDefaultVersion(version.getValue());
            version.addProperty(new ResourceProperty((this.resourceName + "_HOME").toUpperCase(), home.getCanonicalPath(), true, false, false));
            File binDir = new File(home, "bin");
            version.addProperty(new ResourceProperty(this.resourceName + ".bin.dir", binDir.getAbsolutePath(), false, true, false));
            if (SystemUtils.IS_WINDOWS) {
                version.addProperty(new ResourceProperty(this.resourceName + ".bin", new File(binDir, this.scriptName + ".bat").getCanonicalPath(), false, false, false));
            } else {
                version.addProperty(new ResourceProperty(this.resourceName + ".bin", new File(binDir, this.scriptName).getCanonicalPath(), false, false, false));
            }
            File lib = new File(home, "lib");
            if (lib.isDirectory()) {
                version.addProperty(new ResourceProperty(this.resourceName + ".lib.dir", lib.getAbsolutePath(), false, false, false));
            }
            return resource;
        }
        catch (FileLoadException e) {
            e.printStackTrace();
            return null;
        }
    }
}

