/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.resources;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.resources.ResourceConstructor;
import com.zutubi.pulse.util.SystemUtils;
import java.io.File;
import java.io.IOException;

public class JavaResourceConstructor
implements ResourceConstructor {
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String JAVA_BIN_DIR = "java.bin.dir";
    private static final String JAVA_BIN = "java.bin";
    private static final String RESOURCE_NAME = "java";

    public boolean isResourceHome(String home) {
        return home != null && this.isResourceHome(new File(home));
    }

    public boolean isResourceHome(File home) {
        if (home == null || !home.isDirectory()) {
            return false;
        }
        File bin = new File(home, "bin");
        if (SystemUtils.IS_WINDOWS) {
            return new File(bin, "java.exe").isFile();
        }
        return new File(bin, RESOURCE_NAME).isFile();
    }

    public Resource createResource(String home) throws IOException {
        return this.createResource(new File(home));
    }

    public Resource createResource(File home) throws IOException {
        try {
            Resource javaResource = new Resource(RESOURCE_NAME);
            ResourceVersion version = new ResourceVersion(home.getName());
            javaResource.add(version);
            javaResource.setDefaultVersion(version.getValue());
            version.addProperty(new ResourceProperty(JAVA_HOME, home.getCanonicalPath(), true, false, false));
            File binDir = new File(home, "bin");
            version.addProperty(new ResourceProperty(JAVA_BIN_DIR, binDir.getCanonicalPath(), false, true, false));
            if (SystemUtils.IS_WINDOWS) {
                File bin = new File(binDir, "java.exe");
                version.addProperty(new ResourceProperty(JAVA_BIN, bin.getCanonicalPath(), false, false, false));
            } else {
                File bin = new File(binDir, RESOURCE_NAME);
                version.addProperty(new ResourceProperty(JAVA_BIN, bin.getCanonicalPath(), false, false, false));
            }
            return javaResource;
        }
        catch (FileLoadException e) {
            e.printStackTrace();
            return null;
        }
    }
}

