/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

public interface PersonalBuildUI {
    public void setVerbosity(Verbosity var1);

    public void debug(String var1);

    public void status(String var1);

    public void warning(String var1);

    public void error(String var1);

    public void error(String var1, Throwable var2);

    public void enterContext();

    public void exitContext();

    public String inputPrompt(String var1);

    public String inputPrompt(String var1, String var2);

    public String passwordPrompt(String var1);

    public Response ynPrompt(String var1, Response var2);

    public Response ynaPrompt(String var1, Response var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Verbosity {
        QUIET,
        NORMAL,
        VERBOSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Response {
        YES{

            public boolean isAffirmative() {
                return true;
            }

            public boolean isPersistent() {
                return false;
            }
        }
        ,
        NO{

            public boolean isAffirmative() {
                return false;
            }

            public boolean isPersistent() {
                return false;
            }
        }
        ,
        ALWAYS{

            public boolean isAffirmative() {
                return true;
            }

            public boolean isPersistent() {
                return true;
            }
        };


        public abstract boolean isAffirmative();

        public abstract boolean isPersistent();

        public static Response fromInput(String input, Response defaultResponse, Response ... allowedResponses) {
            int length = (input = input.toUpperCase()).length();
            if (length == 0) {
                return defaultResponse;
            }
            if (length == 1) {
                char inputChar = input.charAt(0);
                for (Response r : Response.values()) {
                    if (!Response.in(r, allowedResponses) || r.toString().charAt(0) != inputChar) continue;
                    return r;
                }
            } else {
                try {
                    Response r = Response.valueOf(input);
                    if (Response.in(r, allowedResponses)) {
                        return r;
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return null;
        }

        private static boolean in(Response r, Response ... a) {
            for (Response c : a) {
                if (c != r) continue;
                return true;
            }
            return false;
        }
    }
}

