/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.personal.PersonalBuildWorker;

public abstract class PersonalBuildSupport
implements PersonalBuildWorker {
    private PersonalBuildUI ui;

    public void setUI(PersonalBuildUI ui) {
        this.ui = ui;
    }

    protected void debug(String message, Object ... args) {
        if (this.ui != null) {
            this.ui.debug(String.format(message, args));
        }
    }

    protected void status(String message) {
        if (this.ui != null) {
            this.ui.status(message);
        }
    }

    protected void warning(String message) {
        if (this.ui != null) {
            this.ui.warning(message);
        }
    }

    protected void error(String message) {
        if (this.ui != null) {
            this.ui.error(message);
        }
    }

    protected void error(String message, Throwable throwable) {
        if (this.ui != null) {
            this.ui.error(message, throwable);
        }
    }

    protected void enterContext() {
        if (this.ui != null) {
            this.ui.enterContext();
        }
    }

    protected void exitContext() {
        if (this.ui != null) {
            this.ui.exitContext();
        }
    }

    protected String inputPrompt(String prompt) {
        if (this.ui != null) {
            return this.ui.inputPrompt(prompt);
        }
        return "";
    }

    protected String inputPrompt(String prompt, String defaultResponse) {
        if (this.ui != null) {
            return this.ui.inputPrompt(prompt, defaultResponse);
        }
        return defaultResponse;
    }

    protected String passwordPrompt(String prompt) {
        if (this.ui != null) {
            return this.ui.passwordPrompt(prompt);
        }
        return "";
    }

    protected String readConfirmedPassword(String prompt) {
        if (this.ui != null) {
            while (true) {
                String confirm;
                String password;
                if ((password = this.ui.passwordPrompt(prompt)).equals(confirm = this.ui.passwordPrompt("Confirm"))) {
                    return password;
                }
                this.status("Passwords do not match");
            }
        }
        return "";
    }

    protected PersonalBuildUI.Response ynPrompt(String question, PersonalBuildUI.Response defaultResponse) {
        if (this.ui == null) {
            return defaultResponse;
        }
        return this.ui.ynPrompt(question, defaultResponse);
    }

    protected PersonalBuildUI.Response ynaPrompt(String question, PersonalBuildUI.Response defaultResponse) {
        if (this.ui == null) {
            return defaultResponse;
        }
        return this.ui.ynaPrompt(question, defaultResponse);
    }

    public PersonalBuildUI getUi() {
        return this.ui;
    }

    public boolean hasUI() {
        return this.ui != null;
    }
}

