/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.events;

import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventDispatcher;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.SynchronousDispatcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventManager
implements EventManager {
    private final Map<Class, List<EventListener>> typeToListener = new HashMap<Class, List<EventListener>>();
    private EventDispatcher dispatcher;

    public DefaultEventManager() {
        this(new SynchronousDispatcher());
    }

    public DefaultEventManager(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public synchronized void register(EventListener listener) {
        Class[] clazzes = listener.getHandledEvents();
        if (clazzes == null || clazzes.length == 0) {
            clazzes = new Class[]{Object.class};
        }
        for (Class clazz : clazzes) {
            this.updateTypeToListener(clazz, listener, true);
        }
    }

    @Override
    public synchronized void unregister(EventListener listener) {
        Class[] clazzes;
        for (Class clazz : clazzes = listener.getHandledEvents()) {
            this.updateTypeToListener(clazz, listener, false);
        }
    }

    private void updateTypeToListener(Class clazz, EventListener listener, boolean register) {
        if (!this.typeToListener.containsKey(clazz)) {
            this.typeToListener.put(clazz, new LinkedList());
        }
        List<EventListener> listeners = this.typeToListener.get(clazz);
        if (register) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        } else {
            listeners.remove(listener);
        }
    }

    private Set<EventListener> lookupListeners(Class clazz) {
        Class<?>[] interfaces;
        HashSet<EventListener> listeners = new HashSet<EventListener>();
        if (this.typeToListener.containsKey(clazz)) {
            listeners.addAll((Collection)this.typeToListener.get(clazz));
        }
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            listeners.addAll(this.lookupListeners(i));
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            listeners.addAll(this.lookupListeners(superClass));
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Event evt) {
        Set<EventListener> listeners;
        if (evt == null) {
            return;
        }
        DefaultEventManager defaultEventManager = this;
        synchronized (defaultEventManager) {
            listeners = this.lookupListeners(evt.getClass());
        }
        this.dispatcher.dispatch(evt, new LinkedList<EventListener>(listeners));
    }
}

